/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.transform.OrderMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Order
implements StructuredPojo,
ToCopyableBuilder<Builder, Order> {
    private final String column;
    private final Integer sortOrder;

    private Order(BuilderImpl builder) {
        this.column = builder.column;
        this.sortOrder = builder.sortOrder;
    }

    public String column() {
        return this.column;
    }

    public Integer sortOrder() {
        return this.sortOrder;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.column());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrder());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Order)) {
            return false;
        }
        Order other = (Order)obj;
        return Objects.equals(this.column(), other.column()) && Objects.equals(this.sortOrder(), other.sortOrder());
    }

    public String toString() {
        return ToString.builder((String)"Order").add("Column", (Object)this.column()).add("SortOrder", (Object)this.sortOrder()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Column": {
                return Optional.ofNullable(clazz.cast(this.column()));
            }
            case "SortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrder()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OrderMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String column;
        private Integer sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(Order model) {
            this.column(model.column);
            this.sortOrder(model.sortOrder);
        }

        public final String getColumn() {
            return this.column;
        }

        @Override
        public final Builder column(String column) {
            this.column = column;
            return this;
        }

        public final void setColumn(String column) {
            this.column = column;
        }

        public final Integer getSortOrder() {
            return this.sortOrder;
        }

        @Override
        public final Builder sortOrder(Integer sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public final void setSortOrder(Integer sortOrder) {
            this.sortOrder = sortOrder;
        }

        public Order build() {
            return new Order(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Order> {
        public Builder column(String var1);

        public Builder sortOrder(Integer var1);
    }
}

