/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.transform.JobCommandMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobCommand
implements StructuredPojo,
ToCopyableBuilder<Builder, JobCommand> {
    private final String name;
    private final String scriptLocation;

    private JobCommand(BuilderImpl builder) {
        this.name = builder.name;
        this.scriptLocation = builder.scriptLocation;
    }

    public String name() {
        return this.name;
    }

    public String scriptLocation() {
        return this.scriptLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.scriptLocation());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobCommand)) {
            return false;
        }
        JobCommand other = (JobCommand)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.scriptLocation(), other.scriptLocation());
    }

    public String toString() {
        return ToString.builder((String)"JobCommand").add("Name", (Object)this.name()).add("ScriptLocation", (Object)this.scriptLocation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ScriptLocation": {
                return Optional.ofNullable(clazz.cast(this.scriptLocation()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobCommandMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String scriptLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(JobCommand model) {
            this.name(model.name);
            this.scriptLocation(model.scriptLocation);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getScriptLocation() {
            return this.scriptLocation;
        }

        @Override
        public final Builder scriptLocation(String scriptLocation) {
            this.scriptLocation = scriptLocation;
            return this;
        }

        public final void setScriptLocation(String scriptLocation) {
            this.scriptLocation = scriptLocation;
        }

        public JobCommand build() {
            return new JobCommand(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, JobCommand> {
        public Builder name(String var1);

        public Builder scriptLocation(String var1);
    }
}

