/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.JobBookmarksEncryptionMode;
import software.amazon.awssdk.services.glue.transform.JobBookmarksEncryptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobBookmarksEncryption
implements StructuredPojo,
ToCopyableBuilder<Builder, JobBookmarksEncryption> {
    private final String jobBookmarksEncryptionMode;
    private final String kmsKeyArn;

    private JobBookmarksEncryption(BuilderImpl builder) {
        this.jobBookmarksEncryptionMode = builder.jobBookmarksEncryptionMode;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    public JobBookmarksEncryptionMode jobBookmarksEncryptionMode() {
        return JobBookmarksEncryptionMode.fromValue(this.jobBookmarksEncryptionMode);
    }

    public String jobBookmarksEncryptionModeAsString() {
        return this.jobBookmarksEncryptionMode;
    }

    public String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobBookmarksEncryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobBookmarksEncryption)) {
            return false;
        }
        JobBookmarksEncryption other = (JobBookmarksEncryption)obj;
        return Objects.equals(this.jobBookmarksEncryptionModeAsString(), other.jobBookmarksEncryptionModeAsString()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn());
    }

    public String toString() {
        return ToString.builder((String)"JobBookmarksEncryption").add("JobBookmarksEncryptionMode", (Object)this.jobBookmarksEncryptionModeAsString()).add("KmsKeyArn", (Object)this.kmsKeyArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobBookmarksEncryptionMode": {
                return Optional.ofNullable(clazz.cast(this.jobBookmarksEncryptionModeAsString()));
            }
            case "KmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobBookmarksEncryptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobBookmarksEncryptionMode;
        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(JobBookmarksEncryption model) {
            this.jobBookmarksEncryptionMode(model.jobBookmarksEncryptionMode);
            this.kmsKeyArn(model.kmsKeyArn);
        }

        public final String getJobBookmarksEncryptionMode() {
            return this.jobBookmarksEncryptionMode;
        }

        @Override
        public final Builder jobBookmarksEncryptionMode(String jobBookmarksEncryptionMode) {
            this.jobBookmarksEncryptionMode = jobBookmarksEncryptionMode;
            return this;
        }

        @Override
        public final Builder jobBookmarksEncryptionMode(JobBookmarksEncryptionMode jobBookmarksEncryptionMode) {
            this.jobBookmarksEncryptionMode(jobBookmarksEncryptionMode.toString());
            return this;
        }

        public final void setJobBookmarksEncryptionMode(String jobBookmarksEncryptionMode) {
            this.jobBookmarksEncryptionMode = jobBookmarksEncryptionMode;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        public JobBookmarksEncryption build() {
            return new JobBookmarksEncryption(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, JobBookmarksEncryption> {
        public Builder jobBookmarksEncryptionMode(String var1);

        public Builder jobBookmarksEncryptionMode(JobBookmarksEncryptionMode var1);

        public Builder kmsKeyArn(String var1);
    }
}

