/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.transform.ExecutionPropertyMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecutionProperty
implements StructuredPojo,
ToCopyableBuilder<Builder, ExecutionProperty> {
    private final Integer maxConcurrentRuns;

    private ExecutionProperty(BuilderImpl builder) {
        this.maxConcurrentRuns = builder.maxConcurrentRuns;
    }

    public Integer maxConcurrentRuns() {
        return this.maxConcurrentRuns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrentRuns());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionProperty)) {
            return false;
        }
        ExecutionProperty other = (ExecutionProperty)obj;
        return Objects.equals(this.maxConcurrentRuns(), other.maxConcurrentRuns());
    }

    public String toString() {
        return ToString.builder((String)"ExecutionProperty").add("MaxConcurrentRuns", (Object)this.maxConcurrentRuns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxConcurrentRuns": {
                return Optional.ofNullable(clazz.cast(this.maxConcurrentRuns()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExecutionPropertyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maxConcurrentRuns;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionProperty model) {
            this.maxConcurrentRuns(model.maxConcurrentRuns);
        }

        public final Integer getMaxConcurrentRuns() {
            return this.maxConcurrentRuns;
        }

        @Override
        public final Builder maxConcurrentRuns(Integer maxConcurrentRuns) {
            this.maxConcurrentRuns = maxConcurrentRuns;
            return this;
        }

        public final void setMaxConcurrentRuns(Integer maxConcurrentRuns) {
            this.maxConcurrentRuns = maxConcurrentRuns;
        }

        public ExecutionProperty build() {
            return new ExecutionProperty(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ExecutionProperty> {
        public Builder maxConcurrentRuns(Integer var1);
    }
}

