/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.CloudWatchEncryptionMode;
import software.amazon.awssdk.services.glue.transform.CloudWatchEncryptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudWatchEncryption
implements StructuredPojo,
ToCopyableBuilder<Builder, CloudWatchEncryption> {
    private final String cloudWatchEncryptionMode;
    private final String kmsKeyArn;

    private CloudWatchEncryption(BuilderImpl builder) {
        this.cloudWatchEncryptionMode = builder.cloudWatchEncryptionMode;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    public CloudWatchEncryptionMode cloudWatchEncryptionMode() {
        return CloudWatchEncryptionMode.fromValue(this.cloudWatchEncryptionMode);
    }

    public String cloudWatchEncryptionModeAsString() {
        return this.cloudWatchEncryptionMode;
    }

    public String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchEncryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchEncryption)) {
            return false;
        }
        CloudWatchEncryption other = (CloudWatchEncryption)obj;
        return Objects.equals(this.cloudWatchEncryptionModeAsString(), other.cloudWatchEncryptionModeAsString()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn());
    }

    public String toString() {
        return ToString.builder((String)"CloudWatchEncryption").add("CloudWatchEncryptionMode", (Object)this.cloudWatchEncryptionModeAsString()).add("KmsKeyArn", (Object)this.kmsKeyArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CloudWatchEncryptionMode": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchEncryptionModeAsString()));
            }
            case "KmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CloudWatchEncryptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String cloudWatchEncryptionMode;
        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchEncryption model) {
            this.cloudWatchEncryptionMode(model.cloudWatchEncryptionMode);
            this.kmsKeyArn(model.kmsKeyArn);
        }

        public final String getCloudWatchEncryptionMode() {
            return this.cloudWatchEncryptionMode;
        }

        @Override
        public final Builder cloudWatchEncryptionMode(String cloudWatchEncryptionMode) {
            this.cloudWatchEncryptionMode = cloudWatchEncryptionMode;
            return this;
        }

        @Override
        public final Builder cloudWatchEncryptionMode(CloudWatchEncryptionMode cloudWatchEncryptionMode) {
            this.cloudWatchEncryptionMode(cloudWatchEncryptionMode.toString());
            return this;
        }

        public final void setCloudWatchEncryptionMode(String cloudWatchEncryptionMode) {
            this.cloudWatchEncryptionMode = cloudWatchEncryptionMode;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        public CloudWatchEncryption build() {
            return new CloudWatchEncryption(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CloudWatchEncryption> {
        public Builder cloudWatchEncryptionMode(String var1);

        public Builder cloudWatchEncryptionMode(CloudWatchEncryptionMode var1);

        public Builder kmsKeyArn(String var1);
    }
}

