/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.SkewedInfo;

public class SkewedInfoUnmarshaller
implements Unmarshaller<SkewedInfo, JsonUnmarshallerContext> {
    private static final SkewedInfoUnmarshaller INSTANCE = new SkewedInfoUnmarshaller();

    public SkewedInfo unmarshall(JsonUnmarshallerContext context) throws Exception {
        SkewedInfo.Builder skewedInfoBuilder = SkewedInfo.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("SkewedColumnNames", targetDepth)) {
                    context.nextToken();
                    skewedInfoBuilder.skewedColumnNames(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("SkewedColumnValues", targetDepth)) {
                    context.nextToken();
                    skewedInfoBuilder.skewedColumnValues(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("SkewedColumnValueLocationMaps", targetDepth)) {
                    context.nextToken();
                    skewedInfoBuilder.skewedColumnValueLocationMaps(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (SkewedInfo)skewedInfoBuilder.build();
    }

    public static SkewedInfoUnmarshaller getInstance() {
        return INSTANCE;
    }
}

