/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.ResourceUri;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResourceUriMarshaller {
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceType").isBinary(false).build();
    private static final MarshallingInfo<String> URI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Uri").isBinary(false).build();
    private static final ResourceUriMarshaller INSTANCE = new ResourceUriMarshaller();

    private ResourceUriMarshaller() {
    }

    public static ResourceUriMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResourceUri resourceUri, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)resourceUri, (String)"resourceUri");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)resourceUri.resourceTypeAsString(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)resourceUri.uri(), URI_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

