/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.JobRun;
import software.amazon.awssdk.services.glue.transform.PredecessorUnmarshaller;

public class JobRunUnmarshaller
implements Unmarshaller<JobRun, JsonUnmarshallerContext> {
    private static final JobRunUnmarshaller INSTANCE = new JobRunUnmarshaller();

    public JobRun unmarshall(JsonUnmarshallerContext context) throws Exception {
        JobRun.Builder jobRunBuilder = JobRun.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Id", targetDepth)) {
                    context.nextToken();
                    jobRunBuilder.id((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Attempt", targetDepth)) {
                    context.nextToken();
                    jobRunBuilder.attempt((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("PreviousRunId", targetDepth)) {
                    context.nextToken();
                    jobRunBuilder.previousRunId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("TriggerName", targetDepth)) {
                    context.nextToken();
                    jobRunBuilder.triggerName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("JobName", targetDepth)) {
                    context.nextToken();
                    jobRunBuilder.jobName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("StartedOn", targetDepth)) {
                    context.nextToken();
                    jobRunBuilder.startedOn((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("LastModifiedOn", targetDepth)) {
                    context.nextToken();
                    jobRunBuilder.lastModifiedOn((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("CompletedOn", targetDepth)) {
                    context.nextToken();
                    jobRunBuilder.completedOn((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("JobRunState", targetDepth)) {
                    context.nextToken();
                    jobRunBuilder.jobRunState((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Arguments", targetDepth)) {
                    context.nextToken();
                    jobRunBuilder.arguments(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("ErrorMessage", targetDepth)) {
                    context.nextToken();
                    jobRunBuilder.errorMessage((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("PredecessorRuns", targetDepth)) {
                    context.nextToken();
                    jobRunBuilder.predecessorRuns(new ListUnmarshaller((Unmarshaller)PredecessorUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("AllocatedCapacity", targetDepth)) {
                    context.nextToken();
                    jobRunBuilder.allocatedCapacity((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (JobRun)jobRunBuilder.build();
    }

    public static JobRunUnmarshaller getInstance() {
        return INSTANCE;
    }
}

