/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.JobBookmarkEntry;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class JobBookmarkEntryMarshaller {
    private static final MarshallingInfo<String> JOBNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobName").isBinary(false).build();
    private static final MarshallingInfo<Integer> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Version").isBinary(false).build();
    private static final MarshallingInfo<Integer> RUN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Run").isBinary(false).build();
    private static final MarshallingInfo<Integer> ATTEMPT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attempt").isBinary(false).build();
    private static final MarshallingInfo<String> JOBBOOKMARK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobBookmark").isBinary(false).build();
    private static final JobBookmarkEntryMarshaller INSTANCE = new JobBookmarkEntryMarshaller();

    private JobBookmarkEntryMarshaller() {
    }

    public static JobBookmarkEntryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(JobBookmarkEntry jobBookmarkEntry, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)jobBookmarkEntry, (String)"jobBookmarkEntry");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)jobBookmarkEntry.jobName(), JOBNAME_BINDING);
            protocolMarshaller.marshall((Object)jobBookmarkEntry.version(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)jobBookmarkEntry.run(), RUN_BINDING);
            protocolMarshaller.marshall((Object)jobBookmarkEntry.attempt(), ATTEMPT_BINDING);
            protocolMarshaller.marshall((Object)jobBookmarkEntry.jobBookmark(), JOBBOOKMARK_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

