/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.CreateXMLClassifierRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateXMLClassifierRequestMarshaller {
    private static final MarshallingInfo<String> CLASSIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Classification").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> ROWTAG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RowTag").isBinary(false).build();
    private static final CreateXMLClassifierRequestMarshaller INSTANCE = new CreateXMLClassifierRequestMarshaller();

    private CreateXMLClassifierRequestMarshaller() {
    }

    public static CreateXMLClassifierRequestMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateXMLClassifierRequest createXMLClassifierRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)createXMLClassifierRequest, (String)"createXMLClassifierRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createXMLClassifierRequest.classification(), CLASSIFICATION_BINDING);
            protocolMarshaller.marshall((Object)createXMLClassifierRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)createXMLClassifierRequest.rowTag(), ROWTAG_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

