/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.CreateClassifierRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateClassifierRequestModelMarshaller {
    private static final MarshallingInfo<StructuredPojo> GROKCLASSIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GrokClassifier").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> XMLCLASSIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("XMLClassifier").isBinary(false).build();
    private static final CreateClassifierRequestModelMarshaller INSTANCE = new CreateClassifierRequestModelMarshaller();

    private CreateClassifierRequestModelMarshaller() {
    }

    public static CreateClassifierRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateClassifierRequest createClassifierRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createClassifierRequest), (String)"createClassifierRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createClassifierRequest.grokClassifier(), GROKCLASSIFIER_BINDING);
            protocolMarshaller.marshall((Object)createClassifierRequest.xmlClassifier(), XMLCLASSIFIER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

