/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.Classifier;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ClassifierMarshaller {
    private static final MarshallingInfo<StructuredPojo> GROKCLASSIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GrokClassifier").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> XMLCLASSIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("XMLClassifier").isBinary(false).build();
    private static final ClassifierMarshaller INSTANCE = new ClassifierMarshaller();

    private ClassifierMarshaller() {
    }

    public static ClassifierMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Classifier classifier, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)classifier, (String)"classifier");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)classifier.grokClassifier(), GROKCLASSIFIER_BINDING);
            protocolMarshaller.marshall((Object)classifier.xmlClassifier(), XMLCLASSIFIER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

