/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.CatalogImportStatus;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CatalogImportStatusMarshaller {
    private static final MarshallingInfo<Boolean> IMPORTCOMPLETED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImportCompleted").isBinary(false).build();
    private static final MarshallingInfo<Instant> IMPORTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImportTime").isBinary(false).build();
    private static final MarshallingInfo<String> IMPORTEDBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImportedBy").isBinary(false).build();
    private static final CatalogImportStatusMarshaller INSTANCE = new CatalogImportStatusMarshaller();

    private CatalogImportStatusMarshaller() {
    }

    public static CatalogImportStatusMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CatalogImportStatus catalogImportStatus, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)catalogImportStatus, (String)"catalogImportStatus");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)catalogImportStatus.importCompleted(), IMPORTCOMPLETED_BINDING);
            protocolMarshaller.marshall((Object)catalogImportStatus.importTime(), IMPORTTIME_BINDING);
            protocolMarshaller.marshall((Object)catalogImportStatus.importedBy(), IMPORTEDBY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

