/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.CatalogEntry;

public class CatalogEntryUnmarshaller
implements Unmarshaller<CatalogEntry, JsonUnmarshallerContext> {
    private static final CatalogEntryUnmarshaller INSTANCE = new CatalogEntryUnmarshaller();

    public CatalogEntry unmarshall(JsonUnmarshallerContext context) throws Exception {
        CatalogEntry.Builder catalogEntryBuilder = CatalogEntry.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("DatabaseName", targetDepth)) {
                    context.nextToken();
                    catalogEntryBuilder.databaseName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("TableName", targetDepth)) {
                    context.nextToken();
                    catalogEntryBuilder.tableName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (CatalogEntry)catalogEntryBuilder.build();
    }

    public static CatalogEntryUnmarshaller getInstance() {
        return INSTANCE;
    }
}

