/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.GetJobRunsRequest;
import software.amazon.awssdk.services.glue.model.GetJobRunsResponse;

public class GetJobRunsIterable
implements SdkIterable<GetJobRunsResponse> {
    private final GlueClient client;
    private final GetJobRunsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetJobRunsIterable(GlueClient client, GetJobRunsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetJobRunsResponseFetcher();
    }

    public Iterator<GetJobRunsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final GetJobRunsIterable resume(GetJobRunsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetJobRunsIterable(this.client, (GetJobRunsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetJobRunsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetJobRunsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetJobRunsResponseFetcher
    implements SyncPageFetcher<GetJobRunsResponse> {
        private GetJobRunsResponseFetcher() {
        }

        public boolean hasNextPage(GetJobRunsResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public GetJobRunsResponse nextPage(GetJobRunsResponse previousPage) {
            if (previousPage == null) {
                return GetJobRunsIterable.this.client.getJobRuns(GetJobRunsIterable.this.firstRequest);
            }
            return GetJobRunsIterable.this.client.getJobRuns((GetJobRunsRequest)((Object)GetJobRunsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

