/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.GetDatabasesRequest;
import software.amazon.awssdk.services.glue.model.GetDatabasesResponse;

public class GetDatabasesIterable
implements SdkIterable<GetDatabasesResponse> {
    private final GlueClient client;
    private final GetDatabasesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetDatabasesIterable(GlueClient client, GetDatabasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetDatabasesResponseFetcher();
    }

    public Iterator<GetDatabasesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final GetDatabasesIterable resume(GetDatabasesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetDatabasesIterable(this.client, (GetDatabasesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetDatabasesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetDatabasesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetDatabasesResponseFetcher
    implements SyncPageFetcher<GetDatabasesResponse> {
        private GetDatabasesResponseFetcher() {
        }

        public boolean hasNextPage(GetDatabasesResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public GetDatabasesResponse nextPage(GetDatabasesResponse previousPage) {
            if (previousPage == null) {
                return GetDatabasesIterable.this.client.getDatabases(GetDatabasesIterable.this.firstRequest);
            }
            return GetDatabasesIterable.this.client.getDatabases((GetDatabasesRequest)((Object)GetDatabasesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

