/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.GrokClassifier;
import software.amazon.awssdk.services.glue.model.XMLClassifier;
import software.amazon.awssdk.services.glue.transform.ClassifierMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Classifier
implements StructuredPojo,
ToCopyableBuilder<Builder, Classifier> {
    private final GrokClassifier grokClassifier;
    private final XMLClassifier xmlClassifier;

    private Classifier(BuilderImpl builder) {
        this.grokClassifier = builder.grokClassifier;
        this.xmlClassifier = builder.xmlClassifier;
    }

    public GrokClassifier grokClassifier() {
        return this.grokClassifier;
    }

    public XMLClassifier xmlClassifier() {
        return this.xmlClassifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.grokClassifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.xmlClassifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Classifier)) {
            return false;
        }
        Classifier other = (Classifier)obj;
        return Objects.equals(this.grokClassifier(), other.grokClassifier()) && Objects.equals(this.xmlClassifier(), other.xmlClassifier());
    }

    public String toString() {
        return ToString.builder((String)"Classifier").add("GrokClassifier", (Object)this.grokClassifier()).add("XMLClassifier", (Object)this.xmlClassifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GrokClassifier": {
                return Optional.ofNullable(clazz.cast(this.grokClassifier()));
            }
            case "XMLClassifier": {
                return Optional.ofNullable(clazz.cast(this.xmlClassifier()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ClassifierMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private GrokClassifier grokClassifier;
        private XMLClassifier xmlClassifier;

        private BuilderImpl() {
        }

        private BuilderImpl(Classifier model) {
            this.grokClassifier(model.grokClassifier);
            this.xmlClassifier(model.xmlClassifier);
        }

        public final GrokClassifier.Builder getGrokClassifier() {
            return this.grokClassifier != null ? this.grokClassifier.toBuilder() : null;
        }

        @Override
        public final Builder grokClassifier(GrokClassifier grokClassifier) {
            this.grokClassifier = grokClassifier;
            return this;
        }

        public final void setGrokClassifier(GrokClassifier.BuilderImpl grokClassifier) {
            this.grokClassifier = grokClassifier != null ? grokClassifier.build() : null;
        }

        public final XMLClassifier.Builder getXMLClassifier() {
            return this.xmlClassifier != null ? this.xmlClassifier.toBuilder() : null;
        }

        @Override
        public final Builder xmlClassifier(XMLClassifier xmlClassifier) {
            this.xmlClassifier = xmlClassifier;
            return this;
        }

        public final void setXMLClassifier(XMLClassifier.BuilderImpl xmlClassifier) {
            this.xmlClassifier = xmlClassifier != null ? xmlClassifier.build() : null;
        }

        public Classifier build() {
            return new Classifier(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Classifier> {
        public Builder grokClassifier(GrokClassifier var1);

        default public Builder grokClassifier(Consumer<GrokClassifier.Builder> grokClassifier) {
            return this.grokClassifier((GrokClassifier)((GrokClassifier.Builder)GrokClassifier.builder().applyMutation(grokClassifier)).build());
        }

        public Builder xmlClassifier(XMLClassifier var1);

        default public Builder xmlClassifier(Consumer<XMLClassifier.Builder> xmlClassifier) {
            return this.xmlClassifier((XMLClassifier)((XMLClassifier.Builder)XMLClassifier.builder().applyMutation(xmlClassifier)).build());
        }
    }
}

