/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.ErrorDetail;
import software.amazon.awssdk.services.glue.transform.BatchStopJobRunErrorMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchStopJobRunError
implements StructuredPojo,
ToCopyableBuilder<Builder, BatchStopJobRunError> {
    private final String jobName;
    private final String jobRunId;
    private final ErrorDetail errorDetail;

    private BatchStopJobRunError(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.jobRunId = builder.jobRunId;
        this.errorDetail = builder.errorDetail;
    }

    public String jobName() {
        return this.jobName;
    }

    public String jobRunId() {
        return this.jobRunId;
    }

    public ErrorDetail errorDetail() {
        return this.errorDetail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorDetail());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchStopJobRunError)) {
            return false;
        }
        BatchStopJobRunError other = (BatchStopJobRunError)obj;
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobRunId(), other.jobRunId()) && Objects.equals(this.errorDetail(), other.errorDetail());
    }

    public String toString() {
        return ToString.builder((String)"BatchStopJobRunError").add("JobName", (Object)this.jobName()).add("JobRunId", (Object)this.jobRunId()).add("ErrorDetail", (Object)this.errorDetail()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "JobRunId": {
                return Optional.ofNullable(clazz.cast(this.jobRunId()));
            }
            case "ErrorDetail": {
                return Optional.ofNullable(clazz.cast(this.errorDetail()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchStopJobRunErrorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobName;
        private String jobRunId;
        private ErrorDetail errorDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchStopJobRunError model) {
            this.jobName(model.jobName);
            this.jobRunId(model.jobRunId);
            this.errorDetail(model.errorDetail);
        }

        public final String getJobName() {
            return this.jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final String getJobRunId() {
            return this.jobRunId;
        }

        @Override
        public final Builder jobRunId(String jobRunId) {
            this.jobRunId = jobRunId;
            return this;
        }

        public final void setJobRunId(String jobRunId) {
            this.jobRunId = jobRunId;
        }

        public final ErrorDetail.Builder getErrorDetail() {
            return this.errorDetail != null ? this.errorDetail.toBuilder() : null;
        }

        @Override
        public final Builder errorDetail(ErrorDetail errorDetail) {
            this.errorDetail = errorDetail;
            return this;
        }

        public final void setErrorDetail(ErrorDetail.BuilderImpl errorDetail) {
            this.errorDetail = errorDetail != null ? errorDetail.build() : null;
        }

        public BatchStopJobRunError build() {
            return new BatchStopJobRunError(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchStopJobRunError> {
        public Builder jobName(String var1);

        public Builder jobRunId(String var1);

        public Builder errorDetail(ErrorDetail var1);

        default public Builder errorDetail(Consumer<ErrorDetail.Builder> errorDetail) {
            return this.errorDetail((ErrorDetail)((ErrorDetail.Builder)ErrorDetail.builder().applyMutation(errorDetail)).build());
        }
    }
}

