/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.PartitionError;
import software.amazon.awssdk.services.glue.model.PartitionErrorsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeletePartitionResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, BatchDeletePartitionResponse> {
    private final List<PartitionError> errors;

    private BatchDeletePartitionResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
    }

    public List<PartitionError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.errors());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeletePartitionResponse)) {
            return false;
        }
        BatchDeletePartitionResponse other = (BatchDeletePartitionResponse)((Object)obj);
        return Objects.equals(this.errors(), other.errors());
    }

    public String toString() {
        return ToString.builder((String)"BatchDeletePartitionResponse").add("Errors", this.errors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<PartitionError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeletePartitionResponse model) {
            super(model);
            this.errors(model.errors);
        }

        public final Collection<PartitionError.Builder> getErrors() {
            return this.errors != null ? (Collection)this.errors.stream().map(PartitionError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errors(Collection<PartitionError> errors) {
            this.errors = PartitionErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(PartitionError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<PartitionError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (PartitionError)((PartitionError.Builder)PartitionError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<PartitionError.BuilderImpl> errors) {
            this.errors = PartitionErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public BatchDeletePartitionResponse build() {
            return new BatchDeletePartitionResponse(this);
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    CopyableBuilder<Builder, BatchDeletePartitionResponse> {
        public Builder errors(Collection<PartitionError> var1);

        public Builder errors(PartitionError ... var1);

        public Builder errors(Consumer<PartitionError.Builder> ... var1);
    }
}

