/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.DeleteConnectionNameListCopier;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteConnectionRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, BatchDeleteConnectionRequest> {
    private final String catalogId;
    private final List<String> connectionNameList;

    private BatchDeleteConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.connectionNameList = builder.connectionNameList;
    }

    public String catalogId() {
        return this.catalogId;
    }

    public List<String> connectionNameList() {
        return this.connectionNameList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionNameList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteConnectionRequest)) {
            return false;
        }
        BatchDeleteConnectionRequest other = (BatchDeleteConnectionRequest)((Object)obj);
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.connectionNameList(), other.connectionNameList());
    }

    public String toString() {
        return ToString.builder((String)"BatchDeleteConnectionRequest").add("CatalogId", (Object)this.catalogId()).add("ConnectionNameList", this.connectionNameList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "ConnectionNameList": {
                return Optional.ofNullable(clazz.cast(this.connectionNameList()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String catalogId;
        private List<String> connectionNameList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteConnectionRequest model) {
            super(model);
            this.catalogId(model.catalogId);
            this.connectionNameList(model.connectionNameList);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        public final Collection<String> getConnectionNameList() {
            return this.connectionNameList;
        }

        @Override
        public final Builder connectionNameList(Collection<String> connectionNameList) {
            this.connectionNameList = DeleteConnectionNameListCopier.copy(connectionNameList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionNameList(String ... connectionNameList) {
            this.connectionNameList(Arrays.asList(connectionNameList));
            return this;
        }

        public final void setConnectionNameList(Collection<String> connectionNameList) {
            this.connectionNameList = DeleteConnectionNameListCopier.copy(connectionNameList);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteConnectionRequest build() {
            return new BatchDeleteConnectionRequest(this);
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    CopyableBuilder<Builder, BatchDeleteConnectionRequest> {
        public Builder catalogId(String var1);

        public Builder connectionNameList(Collection<String> var1);

        public Builder connectionNameList(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

