/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.globalaccelerator.model.AcceleratorEvent;
import software.amazon.awssdk.services.globalaccelerator.model.AcceleratorEventsCopier;
import software.amazon.awssdk.services.globalaccelerator.model.AcceleratorStatus;
import software.amazon.awssdk.services.globalaccelerator.model.IpAddressType;
import software.amazon.awssdk.services.globalaccelerator.model.IpSet;
import software.amazon.awssdk.services.globalaccelerator.model.IpSetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Accelerator
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Accelerator> {
    private static final SdkField<String> ACCELERATOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcceleratorArn").getter(Accelerator.getter(Accelerator::acceleratorArn)).setter(Accelerator.setter(Builder::acceleratorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Accelerator.getter(Accelerator::name)).setter(Accelerator.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddressType").getter(Accelerator.getter(Accelerator::ipAddressTypeAsString)).setter(Accelerator.setter(Builder::ipAddressType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddressType").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(Accelerator.getter(Accelerator::enabled)).setter(Accelerator.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<List<IpSet>> IP_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IpSets").getter(Accelerator.getter(Accelerator::ipSets)).setter(Accelerator.setter(Builder::ipSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DnsName").getter(Accelerator.getter(Accelerator::dnsName)).setter(Accelerator.setter(Builder::dnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Accelerator.getter(Accelerator::statusAsString)).setter(Accelerator.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(Accelerator.getter(Accelerator::createdTime)).setter(Accelerator.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(Accelerator.getter(Accelerator::lastModifiedTime)).setter(Accelerator.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> DUAL_STACK_DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DualStackDnsName").getter(Accelerator.getter(Accelerator::dualStackDnsName)).setter(Accelerator.setter(Builder::dualStackDnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DualStackDnsName").build()}).build();
    private static final SdkField<List<AcceleratorEvent>> EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Events").getter(Accelerator.getter(Accelerator::events)).setter(Accelerator.setter(Builder::events)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Events").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AcceleratorEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATOR_ARN_FIELD, NAME_FIELD, IP_ADDRESS_TYPE_FIELD, ENABLED_FIELD, IP_SETS_FIELD, DNS_NAME_FIELD, STATUS_FIELD, CREATED_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, DUAL_STACK_DNS_NAME_FIELD, EVENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Accelerator.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String acceleratorArn;
    private final String name;
    private final String ipAddressType;
    private final Boolean enabled;
    private final List<IpSet> ipSets;
    private final String dnsName;
    private final String status;
    private final Instant createdTime;
    private final Instant lastModifiedTime;
    private final String dualStackDnsName;
    private final List<AcceleratorEvent> events;

    private Accelerator(BuilderImpl builder) {
        this.acceleratorArn = builder.acceleratorArn;
        this.name = builder.name;
        this.ipAddressType = builder.ipAddressType;
        this.enabled = builder.enabled;
        this.ipSets = builder.ipSets;
        this.dnsName = builder.dnsName;
        this.status = builder.status;
        this.createdTime = builder.createdTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.dualStackDnsName = builder.dualStackDnsName;
        this.events = builder.events;
    }

    public final String acceleratorArn() {
        return this.acceleratorArn;
    }

    public final String name() {
        return this.name;
    }

    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(this.ipAddressType);
    }

    public final String ipAddressTypeAsString() {
        return this.ipAddressType;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final boolean hasIpSets() {
        return this.ipSets != null && !(this.ipSets instanceof SdkAutoConstructList);
    }

    public final List<IpSet> ipSets() {
        return this.ipSets;
    }

    public final String dnsName() {
        return this.dnsName;
    }

    public final AcceleratorStatus status() {
        return AcceleratorStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String dualStackDnsName() {
        return this.dualStackDnsName;
    }

    public final boolean hasEvents() {
        return this.events != null && !(this.events instanceof SdkAutoConstructList);
    }

    public final List<AcceleratorEvent> events() {
        return this.events;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acceleratorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpSets() ? this.ipSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dualStackDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvents() ? this.events() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Accelerator)) {
            return false;
        }
        Accelerator other = (Accelerator)obj;
        return Objects.equals(this.acceleratorArn(), other.acceleratorArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.ipAddressTypeAsString(), other.ipAddressTypeAsString()) && Objects.equals(this.enabled(), other.enabled()) && this.hasIpSets() == other.hasIpSets() && Objects.equals(this.ipSets(), other.ipSets()) && Objects.equals(this.dnsName(), other.dnsName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.dualStackDnsName(), other.dualStackDnsName()) && this.hasEvents() == other.hasEvents() && Objects.equals(this.events(), other.events());
    }

    public final String toString() {
        return ToString.builder((String)"Accelerator").add("AcceleratorArn", (Object)this.acceleratorArn()).add("Name", (Object)this.name()).add("IpAddressType", (Object)this.ipAddressTypeAsString()).add("Enabled", (Object)this.enabled()).add("IpSets", this.hasIpSets() ? this.ipSets() : null).add("DnsName", (Object)this.dnsName()).add("Status", (Object)this.statusAsString()).add("CreatedTime", (Object)this.createdTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("DualStackDnsName", (Object)this.dualStackDnsName()).add("Events", this.hasEvents() ? this.events() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceleratorArn": {
                return Optional.ofNullable(clazz.cast(this.acceleratorArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "IpAddressType": {
                return Optional.ofNullable(clazz.cast(this.ipAddressTypeAsString()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "IpSets": {
                return Optional.ofNullable(clazz.cast(this.ipSets()));
            }
            case "DnsName": {
                return Optional.ofNullable(clazz.cast(this.dnsName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "DualStackDnsName": {
                return Optional.ofNullable(clazz.cast(this.dualStackDnsName()));
            }
            case "Events": {
                return Optional.ofNullable(clazz.cast(this.events()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AcceleratorArn", ACCELERATOR_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("IpAddressType", IP_ADDRESS_TYPE_FIELD);
        map.put("Enabled", ENABLED_FIELD);
        map.put("IpSets", IP_SETS_FIELD);
        map.put("DnsName", DNS_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("DualStackDnsName", DUAL_STACK_DNS_NAME_FIELD);
        map.put("Events", EVENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Accelerator, T> g) {
        return obj -> g.apply((Accelerator)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String acceleratorArn;
        private String name;
        private String ipAddressType;
        private Boolean enabled;
        private List<IpSet> ipSets = DefaultSdkAutoConstructList.getInstance();
        private String dnsName;
        private String status;
        private Instant createdTime;
        private Instant lastModifiedTime;
        private String dualStackDnsName;
        private List<AcceleratorEvent> events = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Accelerator model) {
            this.acceleratorArn(model.acceleratorArn);
            this.name(model.name);
            this.ipAddressType(model.ipAddressType);
            this.enabled(model.enabled);
            this.ipSets(model.ipSets);
            this.dnsName(model.dnsName);
            this.status(model.status);
            this.createdTime(model.createdTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.dualStackDnsName(model.dualStackDnsName);
            this.events(model.events);
        }

        public final String getAcceleratorArn() {
            return this.acceleratorArn;
        }

        public final void setAcceleratorArn(String acceleratorArn) {
            this.acceleratorArn = acceleratorArn;
        }

        @Override
        public final Builder acceleratorArn(String acceleratorArn) {
            this.acceleratorArn = acceleratorArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getIpAddressType() {
            return this.ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final List<IpSet.Builder> getIpSets() {
            List<IpSet.Builder> result = IpSetsCopier.copyToBuilder(this.ipSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpSets(Collection<IpSet.BuilderImpl> ipSets) {
            this.ipSets = IpSetsCopier.copyFromBuilder(ipSets);
        }

        @Override
        public final Builder ipSets(Collection<IpSet> ipSets) {
            this.ipSets = IpSetsCopier.copy(ipSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipSets(IpSet ... ipSets) {
            this.ipSets(Arrays.asList(ipSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipSets(Consumer<IpSet.Builder> ... ipSets) {
            this.ipSets(Stream.of(ipSets).map(c -> (IpSet)((IpSet.Builder)IpSet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDnsName() {
            return this.dnsName;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AcceleratorStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getDualStackDnsName() {
            return this.dualStackDnsName;
        }

        public final void setDualStackDnsName(String dualStackDnsName) {
            this.dualStackDnsName = dualStackDnsName;
        }

        @Override
        public final Builder dualStackDnsName(String dualStackDnsName) {
            this.dualStackDnsName = dualStackDnsName;
            return this;
        }

        public final List<AcceleratorEvent.Builder> getEvents() {
            List<AcceleratorEvent.Builder> result = AcceleratorEventsCopier.copyToBuilder(this.events);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvents(Collection<AcceleratorEvent.BuilderImpl> events) {
            this.events = AcceleratorEventsCopier.copyFromBuilder(events);
        }

        @Override
        public final Builder events(Collection<AcceleratorEvent> events) {
            this.events = AcceleratorEventsCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(AcceleratorEvent ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Consumer<AcceleratorEvent.Builder> ... events) {
            this.events(Stream.of(events).map(c -> (AcceleratorEvent)((AcceleratorEvent.Builder)AcceleratorEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Accelerator build() {
            return new Accelerator(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Accelerator> {
        public Builder acceleratorArn(String var1);

        public Builder name(String var1);

        public Builder ipAddressType(String var1);

        public Builder ipAddressType(IpAddressType var1);

        public Builder enabled(Boolean var1);

        public Builder ipSets(Collection<IpSet> var1);

        public Builder ipSets(IpSet ... var1);

        public Builder ipSets(Consumer<IpSet.Builder> ... var1);

        public Builder dnsName(String var1);

        public Builder status(String var1);

        public Builder status(AcceleratorStatus var1);

        public Builder createdTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder dualStackDnsName(String var1);

        public Builder events(Collection<AcceleratorEvent> var1);

        public Builder events(AcceleratorEvent ... var1);

        public Builder events(Consumer<AcceleratorEvent.Builder> ... var1);
    }
}

