/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.globalaccelerator.model.ClientAffinity;
import software.amazon.awssdk.services.globalaccelerator.model.GlobalAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.PortRange;
import software.amazon.awssdk.services.globalaccelerator.model.PortRangesCopier;
import software.amazon.awssdk.services.globalaccelerator.model.Protocol;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateListenerRequest
extends GlobalAcceleratorRequest
implements ToCopyableBuilder<Builder, CreateListenerRequest> {
    private static final SdkField<String> ACCELERATOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcceleratorArn").getter(CreateListenerRequest.getter(CreateListenerRequest::acceleratorArn)).setter(CreateListenerRequest.setter(Builder::acceleratorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorArn").build()}).build();
    private static final SdkField<List<PortRange>> PORT_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PortRanges").getter(CreateListenerRequest.getter(CreateListenerRequest::portRanges)).setter(CreateListenerRequest.setter(Builder::portRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortRanges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PortRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(CreateListenerRequest.getter(CreateListenerRequest::protocolAsString)).setter(CreateListenerRequest.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()}).build();
    private static final SdkField<String> CLIENT_AFFINITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientAffinity").getter(CreateListenerRequest.getter(CreateListenerRequest::clientAffinityAsString)).setter(CreateListenerRequest.setter(Builder::clientAffinity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientAffinity").build()}).build();
    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdempotencyToken").getter(CreateListenerRequest.getter(CreateListenerRequest::idempotencyToken)).setter(CreateListenerRequest.setter(Builder::idempotencyToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATOR_ARN_FIELD, PORT_RANGES_FIELD, PROTOCOL_FIELD, CLIENT_AFFINITY_FIELD, IDEMPOTENCY_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateListenerRequest.memberNameToFieldInitializer();
    private final String acceleratorArn;
    private final List<PortRange> portRanges;
    private final String protocol;
    private final String clientAffinity;
    private final String idempotencyToken;

    private CreateListenerRequest(BuilderImpl builder) {
        super(builder);
        this.acceleratorArn = builder.acceleratorArn;
        this.portRanges = builder.portRanges;
        this.protocol = builder.protocol;
        this.clientAffinity = builder.clientAffinity;
        this.idempotencyToken = builder.idempotencyToken;
    }

    public final String acceleratorArn() {
        return this.acceleratorArn;
    }

    public final boolean hasPortRanges() {
        return this.portRanges != null && !(this.portRanges instanceof SdkAutoConstructList);
    }

    public final List<PortRange> portRanges() {
        return this.portRanges;
    }

    public final Protocol protocol() {
        return Protocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final ClientAffinity clientAffinity() {
        return ClientAffinity.fromValue(this.clientAffinity);
    }

    public final String clientAffinityAsString() {
        return this.clientAffinity;
    }

    public final String idempotencyToken() {
        return this.idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.acceleratorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPortRanges() ? this.portRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientAffinityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateListenerRequest)) {
            return false;
        }
        CreateListenerRequest other = (CreateListenerRequest)((Object)obj);
        return Objects.equals(this.acceleratorArn(), other.acceleratorArn()) && this.hasPortRanges() == other.hasPortRanges() && Objects.equals(this.portRanges(), other.portRanges()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.clientAffinityAsString(), other.clientAffinityAsString()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateListenerRequest").add("AcceleratorArn", (Object)this.acceleratorArn()).add("PortRanges", this.hasPortRanges() ? this.portRanges() : null).add("Protocol", (Object)this.protocolAsString()).add("ClientAffinity", (Object)this.clientAffinityAsString()).add("IdempotencyToken", (Object)this.idempotencyToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceleratorArn": {
                return Optional.ofNullable(clazz.cast(this.acceleratorArn()));
            }
            case "PortRanges": {
                return Optional.ofNullable(clazz.cast(this.portRanges()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "ClientAffinity": {
                return Optional.ofNullable(clazz.cast(this.clientAffinityAsString()));
            }
            case "IdempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AcceleratorArn", ACCELERATOR_ARN_FIELD);
        map.put("PortRanges", PORT_RANGES_FIELD);
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("ClientAffinity", CLIENT_AFFINITY_FIELD);
        map.put("IdempotencyToken", IDEMPOTENCY_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateListenerRequest, T> g) {
        return obj -> g.apply((CreateListenerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlobalAcceleratorRequest.BuilderImpl
    implements Builder {
        private String acceleratorArn;
        private List<PortRange> portRanges = DefaultSdkAutoConstructList.getInstance();
        private String protocol;
        private String clientAffinity;
        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateListenerRequest model) {
            super(model);
            this.acceleratorArn(model.acceleratorArn);
            this.portRanges(model.portRanges);
            this.protocol(model.protocol);
            this.clientAffinity(model.clientAffinity);
            this.idempotencyToken(model.idempotencyToken);
        }

        public final String getAcceleratorArn() {
            return this.acceleratorArn;
        }

        public final void setAcceleratorArn(String acceleratorArn) {
            this.acceleratorArn = acceleratorArn;
        }

        @Override
        public final Builder acceleratorArn(String acceleratorArn) {
            this.acceleratorArn = acceleratorArn;
            return this;
        }

        public final List<PortRange.Builder> getPortRanges() {
            List<PortRange.Builder> result = PortRangesCopier.copyToBuilder(this.portRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPortRanges(Collection<PortRange.BuilderImpl> portRanges) {
            this.portRanges = PortRangesCopier.copyFromBuilder(portRanges);
        }

        @Override
        public final Builder portRanges(Collection<PortRange> portRanges) {
            this.portRanges = PortRangesCopier.copy(portRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portRanges(PortRange ... portRanges) {
            this.portRanges(Arrays.asList(portRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portRanges(Consumer<PortRange.Builder> ... portRanges) {
            this.portRanges(Stream.of(portRanges).map(c -> (PortRange)((PortRange.Builder)PortRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final String getClientAffinity() {
            return this.clientAffinity;
        }

        public final void setClientAffinity(String clientAffinity) {
            this.clientAffinity = clientAffinity;
        }

        @Override
        public final Builder clientAffinity(String clientAffinity) {
            this.clientAffinity = clientAffinity;
            return this;
        }

        @Override
        public final Builder clientAffinity(ClientAffinity clientAffinity) {
            this.clientAffinity(clientAffinity == null ? null : clientAffinity.toString());
            return this;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateListenerRequest build() {
            return new CreateListenerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GlobalAcceleratorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateListenerRequest> {
        public Builder acceleratorArn(String var1);

        public Builder portRanges(Collection<PortRange> var1);

        public Builder portRanges(PortRange ... var1);

        public Builder portRanges(Consumer<PortRange.Builder> ... var1);

        public Builder protocol(String var1);

        public Builder protocol(Protocol var1);

        public Builder clientAffinity(String var1);

        public Builder clientAffinity(ClientAffinity var1);

        public Builder idempotencyToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

