/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.globalaccelerator.GlobalAcceleratorClient;
import software.amazon.awssdk.services.globalaccelerator.internal.UserAgentUtils;
import software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingListener;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersResponse;

public class ListCustomRoutingListenersIterable
implements SdkIterable<ListCustomRoutingListenersResponse> {
    private final GlobalAcceleratorClient client;
    private final ListCustomRoutingListenersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCustomRoutingListenersIterable(GlobalAcceleratorClient client, ListCustomRoutingListenersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCustomRoutingListenersResponseFetcher();
    }

    public Iterator<ListCustomRoutingListenersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CustomRoutingListener> listeners() {
        Function<ListCustomRoutingListenersResponse, Iterator> getIterator = response -> {
            if (response != null && response.listeners() != null) {
                return response.listeners().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCustomRoutingListenersResponseFetcher
    implements SyncPageFetcher<ListCustomRoutingListenersResponse> {
        private ListCustomRoutingListenersResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomRoutingListenersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCustomRoutingListenersResponse nextPage(ListCustomRoutingListenersResponse previousPage) {
            if (previousPage == null) {
                return ListCustomRoutingListenersIterable.this.client.listCustomRoutingListeners(ListCustomRoutingListenersIterable.this.firstRequest);
            }
            return ListCustomRoutingListenersIterable.this.client.listCustomRoutingListeners((ListCustomRoutingListenersRequest)((Object)ListCustomRoutingListenersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

