/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.globalaccelerator.GlobalAcceleratorClient;
import software.amazon.awssdk.services.globalaccelerator.internal.UserAgentUtils;
import software.amazon.awssdk.services.globalaccelerator.model.ByoipCidr;
import software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsResponse;

public class ListByoipCidrsIterable
implements SdkIterable<ListByoipCidrsResponse> {
    private final GlobalAcceleratorClient client;
    private final ListByoipCidrsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListByoipCidrsIterable(GlobalAcceleratorClient client, ListByoipCidrsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListByoipCidrsResponseFetcher();
    }

    public Iterator<ListByoipCidrsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ByoipCidr> byoipCidrs() {
        Function<ListByoipCidrsResponse, Iterator> getIterator = response -> {
            if (response != null && response.byoipCidrs() != null) {
                return response.byoipCidrs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListByoipCidrsResponseFetcher
    implements SyncPageFetcher<ListByoipCidrsResponse> {
        private ListByoipCidrsResponseFetcher() {
        }

        public boolean hasNextPage(ListByoipCidrsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListByoipCidrsResponse nextPage(ListByoipCidrsResponse previousPage) {
            if (previousPage == null) {
                return ListByoipCidrsIterable.this.client.listByoipCidrs(ListByoipCidrsIterable.this.firstRequest);
            }
            return ListByoipCidrsIterable.this.client.listByoipCidrs((ListByoipCidrsRequest)((Object)ListByoipCidrsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

