/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IpAddressFamily {
    IP_V4("IPv4"),
    IP_V6("IPv6"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IpAddressFamily> VALUE_MAP;
    private final String value;

    private IpAddressFamily(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IpAddressFamily fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IpAddressFamily> knownValues() {
        EnumSet<IpAddressFamily> knownValues = EnumSet.allOf(IpAddressFamily.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IpAddressFamily.class, IpAddressFamily::toString);
    }
}

