/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.globalaccelerator.GlobalAcceleratorClient;
import software.amazon.awssdk.services.globalaccelerator.internal.UserAgentUtils;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.PortMapping;

public class ListCustomRoutingPortMappingsIterable
implements SdkIterable<ListCustomRoutingPortMappingsResponse> {
    private final GlobalAcceleratorClient client;
    private final ListCustomRoutingPortMappingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCustomRoutingPortMappingsIterable(GlobalAcceleratorClient client, ListCustomRoutingPortMappingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCustomRoutingPortMappingsResponseFetcher();
    }

    public Iterator<ListCustomRoutingPortMappingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PortMapping> portMappings() {
        Function<ListCustomRoutingPortMappingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.portMappings() != null) {
                return response.portMappings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCustomRoutingPortMappingsResponseFetcher
    implements SyncPageFetcher<ListCustomRoutingPortMappingsResponse> {
        private ListCustomRoutingPortMappingsResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomRoutingPortMappingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCustomRoutingPortMappingsResponse nextPage(ListCustomRoutingPortMappingsResponse previousPage) {
            if (previousPage == null) {
                return ListCustomRoutingPortMappingsIterable.this.client.listCustomRoutingPortMappings(ListCustomRoutingPortMappingsIterable.this.firstRequest);
            }
            return ListCustomRoutingPortMappingsIterable.this.client.listCustomRoutingPortMappings((ListCustomRoutingPortMappingsRequest)((Object)ListCustomRoutingPortMappingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

