/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.globalaccelerator.GlobalAcceleratorClient;
import software.amazon.awssdk.services.globalaccelerator.internal.UserAgentUtils;
import software.amazon.awssdk.services.globalaccelerator.model.EndpointGroup;
import software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsResponse;

public class ListEndpointGroupsIterable
implements SdkIterable<ListEndpointGroupsResponse> {
    private final GlobalAcceleratorClient client;
    private final ListEndpointGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEndpointGroupsIterable(GlobalAcceleratorClient client, ListEndpointGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEndpointGroupsResponseFetcher();
    }

    public Iterator<ListEndpointGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EndpointGroup> endpointGroups() {
        Function<ListEndpointGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.endpointGroups() != null) {
                return response.endpointGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEndpointGroupsResponseFetcher
    implements SyncPageFetcher<ListEndpointGroupsResponse> {
        private ListEndpointGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListEndpointGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEndpointGroupsResponse nextPage(ListEndpointGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListEndpointGroupsIterable.this.client.listEndpointGroups(ListEndpointGroupsIterable.this.firstRequest);
            }
            return ListEndpointGroupsIterable.this.client.listEndpointGroups((ListEndpointGroupsRequest)((Object)ListEndpointGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

