/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.globalaccelerator.model.EndpointIdsCopier;
import software.amazon.awssdk.services.globalaccelerator.model.GlobalAcceleratorRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemoveCustomRoutingEndpointsRequest
extends GlobalAcceleratorRequest
implements ToCopyableBuilder<Builder, RemoveCustomRoutingEndpointsRequest> {
    private static final SdkField<List<String>> ENDPOINT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EndpointIds").getter(RemoveCustomRoutingEndpointsRequest.getter(RemoveCustomRoutingEndpointsRequest::endpointIds)).setter(RemoveCustomRoutingEndpointsRequest.setter(Builder::endpointIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ENDPOINT_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointGroupArn").getter(RemoveCustomRoutingEndpointsRequest.getter(RemoveCustomRoutingEndpointsRequest::endpointGroupArn)).setter(RemoveCustomRoutingEndpointsRequest.setter(Builder::endpointGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointGroupArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_IDS_FIELD, ENDPOINT_GROUP_ARN_FIELD));
    private final List<String> endpointIds;
    private final String endpointGroupArn;

    private RemoveCustomRoutingEndpointsRequest(BuilderImpl builder) {
        super(builder);
        this.endpointIds = builder.endpointIds;
        this.endpointGroupArn = builder.endpointGroupArn;
    }

    public final boolean hasEndpointIds() {
        return this.endpointIds != null && !(this.endpointIds instanceof SdkAutoConstructList);
    }

    public final List<String> endpointIds() {
        return this.endpointIds;
    }

    public final String endpointGroupArn() {
        return this.endpointGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpointIds() ? this.endpointIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointGroupArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveCustomRoutingEndpointsRequest)) {
            return false;
        }
        RemoveCustomRoutingEndpointsRequest other = (RemoveCustomRoutingEndpointsRequest)((Object)obj);
        return this.hasEndpointIds() == other.hasEndpointIds() && Objects.equals(this.endpointIds(), other.endpointIds()) && Objects.equals(this.endpointGroupArn(), other.endpointGroupArn());
    }

    public final String toString() {
        return ToString.builder((String)"RemoveCustomRoutingEndpointsRequest").add("EndpointIds", this.hasEndpointIds() ? this.endpointIds() : null).add("EndpointGroupArn", (Object)this.endpointGroupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointIds": {
                return Optional.ofNullable(clazz.cast(this.endpointIds()));
            }
            case "EndpointGroupArn": {
                return Optional.ofNullable(clazz.cast(this.endpointGroupArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemoveCustomRoutingEndpointsRequest, T> g) {
        return obj -> g.apply((RemoveCustomRoutingEndpointsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlobalAcceleratorRequest.BuilderImpl
    implements Builder {
        private List<String> endpointIds = DefaultSdkAutoConstructList.getInstance();
        private String endpointGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveCustomRoutingEndpointsRequest model) {
            super(model);
            this.endpointIds(model.endpointIds);
            this.endpointGroupArn(model.endpointGroupArn);
        }

        public final Collection<String> getEndpointIds() {
            if (this.endpointIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.endpointIds;
        }

        public final void setEndpointIds(Collection<String> endpointIds) {
            this.endpointIds = EndpointIdsCopier.copy(endpointIds);
        }

        @Override
        public final Builder endpointIds(Collection<String> endpointIds) {
            this.endpointIds = EndpointIdsCopier.copy(endpointIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointIds(String ... endpointIds) {
            this.endpointIds(Arrays.asList(endpointIds));
            return this;
        }

        public final String getEndpointGroupArn() {
            return this.endpointGroupArn;
        }

        public final void setEndpointGroupArn(String endpointGroupArn) {
            this.endpointGroupArn = endpointGroupArn;
        }

        @Override
        public final Builder endpointGroupArn(String endpointGroupArn) {
            this.endpointGroupArn = endpointGroupArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemoveCustomRoutingEndpointsRequest build() {
            return new RemoveCustomRoutingEndpointsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlobalAcceleratorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RemoveCustomRoutingEndpointsRequest> {
        public Builder endpointIds(Collection<String> var1);

        public Builder endpointIds(String ... var1);

        public Builder endpointGroupArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

