/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteCustomRoutingAcceleratorRequest extends GlobalAcceleratorRequest implements
        ToCopyableBuilder<DeleteCustomRoutingAcceleratorRequest.Builder, DeleteCustomRoutingAcceleratorRequest> {
    private static final SdkField<String> ACCELERATOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcceleratorArn").getter(getter(DeleteCustomRoutingAcceleratorRequest::acceleratorArn))
            .setter(setter(Builder::acceleratorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATOR_ARN_FIELD));

    private final String acceleratorArn;

    private DeleteCustomRoutingAcceleratorRequest(BuilderImpl builder) {
        super(builder);
        this.acceleratorArn = builder.acceleratorArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the custom routing accelerator to delete.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the custom routing accelerator to delete.
     */
    public final String acceleratorArn() {
        return acceleratorArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acceleratorArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteCustomRoutingAcceleratorRequest)) {
            return false;
        }
        DeleteCustomRoutingAcceleratorRequest other = (DeleteCustomRoutingAcceleratorRequest) obj;
        return Objects.equals(acceleratorArn(), other.acceleratorArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteCustomRoutingAcceleratorRequest").add("AcceleratorArn", acceleratorArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceleratorArn":
            return Optional.ofNullable(clazz.cast(acceleratorArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteCustomRoutingAcceleratorRequest, T> g) {
        return obj -> g.apply((DeleteCustomRoutingAcceleratorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlobalAcceleratorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteCustomRoutingAcceleratorRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the custom routing accelerator to delete.
         * </p>
         * 
         * @param acceleratorArn
         *        The Amazon Resource Name (ARN) of the custom routing accelerator to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorArn(String acceleratorArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlobalAcceleratorRequest.BuilderImpl implements Builder {
        private String acceleratorArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteCustomRoutingAcceleratorRequest model) {
            super(model);
            acceleratorArn(model.acceleratorArn);
        }

        public final String getAcceleratorArn() {
            return acceleratorArn;
        }

        public final void setAcceleratorArn(String acceleratorArn) {
            this.acceleratorArn = acceleratorArn;
        }

        @Override
        public final Builder acceleratorArn(String acceleratorArn) {
            this.acceleratorArn = acceleratorArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteCustomRoutingAcceleratorRequest build() {
            return new DeleteCustomRoutingAcceleratorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
