/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataRetrievalRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataRetrievalRule> {
    private static final SdkField<String> STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DataRetrievalRule.getter(DataRetrievalRule::strategy)).setter(DataRetrievalRule.setter(Builder::strategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Strategy").build()}).build();
    private static final SdkField<Long> BYTES_PER_HOUR_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(DataRetrievalRule.getter(DataRetrievalRule::bytesPerHour)).setter(DataRetrievalRule.setter(Builder::bytesPerHour)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BytesPerHour").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRATEGY_FIELD, BYTES_PER_HOUR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String strategy;
    private final Long bytesPerHour;

    private DataRetrievalRule(BuilderImpl builder) {
        this.strategy = builder.strategy;
        this.bytesPerHour = builder.bytesPerHour;
    }

    public String strategy() {
        return this.strategy;
    }

    public Long bytesPerHour() {
        return this.bytesPerHour;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.strategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.bytesPerHour());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataRetrievalRule)) {
            return false;
        }
        DataRetrievalRule other = (DataRetrievalRule)obj;
        return Objects.equals(this.strategy(), other.strategy()) && Objects.equals(this.bytesPerHour(), other.bytesPerHour());
    }

    public String toString() {
        return ToString.builder((String)"DataRetrievalRule").add("Strategy", (Object)this.strategy()).add("BytesPerHour", (Object)this.bytesPerHour()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Strategy": {
                return Optional.ofNullable(clazz.cast(this.strategy()));
            }
            case "BytesPerHour": {
                return Optional.ofNullable(clazz.cast(this.bytesPerHour()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataRetrievalRule, T> g) {
        return obj -> g.apply((DataRetrievalRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String strategy;
        private Long bytesPerHour;

        private BuilderImpl() {
        }

        private BuilderImpl(DataRetrievalRule model) {
            this.strategy(model.strategy);
            this.bytesPerHour(model.bytesPerHour);
        }

        public final String getStrategy() {
            return this.strategy;
        }

        @Override
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        public final Long getBytesPerHour() {
            return this.bytesPerHour;
        }

        @Override
        public final Builder bytesPerHour(Long bytesPerHour) {
            this.bytesPerHour = bytesPerHour;
            return this;
        }

        public final void setBytesPerHour(Long bytesPerHour) {
            this.bytesPerHour = bytesPerHour;
        }

        public DataRetrievalRule build() {
            return new DataRetrievalRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataRetrievalRule> {
        public Builder strategy(String var1);

        public Builder bytesPerHour(Long var1);
    }
}

