/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glacier.model.GlacierResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVaultResponse
extends GlacierResponse
implements ToCopyableBuilder<Builder, DescribeVaultResponse> {
    private static final SdkField<String> VAULT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VaultARN").getter(DescribeVaultResponse.getter(DescribeVaultResponse::vaultARN)).setter(DescribeVaultResponse.setter(Builder::vaultARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VaultARN").build()}).build();
    private static final SdkField<String> VAULT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VaultName").getter(DescribeVaultResponse.getter(DescribeVaultResponse::vaultName)).setter(DescribeVaultResponse.setter(Builder::vaultName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VaultName").build()}).build();
    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationDate").getter(DescribeVaultResponse.getter(DescribeVaultResponse::creationDate)).setter(DescribeVaultResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<String> LAST_INVENTORY_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastInventoryDate").getter(DescribeVaultResponse.getter(DescribeVaultResponse::lastInventoryDate)).setter(DescribeVaultResponse.setter(Builder::lastInventoryDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastInventoryDate").build()}).build();
    private static final SdkField<Long> NUMBER_OF_ARCHIVES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NumberOfArchives").getter(DescribeVaultResponse.getter(DescribeVaultResponse::numberOfArchives)).setter(DescribeVaultResponse.setter(Builder::numberOfArchives)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfArchives").build()}).build();
    private static final SdkField<Long> SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("SizeInBytes").getter(DescribeVaultResponse.getter(DescribeVaultResponse::sizeInBytes)).setter(DescribeVaultResponse.setter(Builder::sizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeInBytes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VAULT_ARN_FIELD, VAULT_NAME_FIELD, CREATION_DATE_FIELD, LAST_INVENTORY_DATE_FIELD, NUMBER_OF_ARCHIVES_FIELD, SIZE_IN_BYTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("VaultARN", VAULT_ARN_FIELD);
            this.put("VaultName", VAULT_NAME_FIELD);
            this.put("CreationDate", CREATION_DATE_FIELD);
            this.put("LastInventoryDate", LAST_INVENTORY_DATE_FIELD);
            this.put("NumberOfArchives", NUMBER_OF_ARCHIVES_FIELD);
            this.put("SizeInBytes", SIZE_IN_BYTES_FIELD);
        }
    });
    private final String vaultARN;
    private final String vaultName;
    private final String creationDate;
    private final String lastInventoryDate;
    private final Long numberOfArchives;
    private final Long sizeInBytes;

    private DescribeVaultResponse(BuilderImpl builder) {
        super(builder);
        this.vaultARN = builder.vaultARN;
        this.vaultName = builder.vaultName;
        this.creationDate = builder.creationDate;
        this.lastInventoryDate = builder.lastInventoryDate;
        this.numberOfArchives = builder.numberOfArchives;
        this.sizeInBytes = builder.sizeInBytes;
    }

    public final String vaultARN() {
        return this.vaultARN;
    }

    public final String vaultName() {
        return this.vaultName;
    }

    public final String creationDate() {
        return this.creationDate;
    }

    public final String lastInventoryDate() {
        return this.lastInventoryDate;
    }

    public final Long numberOfArchives() {
        return this.numberOfArchives;
    }

    public final Long sizeInBytes() {
        return this.sizeInBytes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.vaultARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.vaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastInventoryDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfArchives());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInBytes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVaultResponse)) {
            return false;
        }
        DescribeVaultResponse other = (DescribeVaultResponse)((Object)obj);
        return Objects.equals(this.vaultARN(), other.vaultARN()) && Objects.equals(this.vaultName(), other.vaultName()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastInventoryDate(), other.lastInventoryDate()) && Objects.equals(this.numberOfArchives(), other.numberOfArchives()) && Objects.equals(this.sizeInBytes(), other.sizeInBytes());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeVaultResponse").add("VaultARN", (Object)this.vaultARN()).add("VaultName", (Object)this.vaultName()).add("CreationDate", (Object)this.creationDate()).add("LastInventoryDate", (Object)this.lastInventoryDate()).add("NumberOfArchives", (Object)this.numberOfArchives()).add("SizeInBytes", (Object)this.sizeInBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VaultARN": {
                return Optional.ofNullable(clazz.cast(this.vaultARN()));
            }
            case "VaultName": {
                return Optional.ofNullable(clazz.cast(this.vaultName()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "LastInventoryDate": {
                return Optional.ofNullable(clazz.cast(this.lastInventoryDate()));
            }
            case "NumberOfArchives": {
                return Optional.ofNullable(clazz.cast(this.numberOfArchives()));
            }
            case "SizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.sizeInBytes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVaultResponse, T> g) {
        return obj -> g.apply((DescribeVaultResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlacierResponse.BuilderImpl
    implements Builder {
        private String vaultARN;
        private String vaultName;
        private String creationDate;
        private String lastInventoryDate;
        private Long numberOfArchives;
        private Long sizeInBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVaultResponse model) {
            super(model);
            this.vaultARN(model.vaultARN);
            this.vaultName(model.vaultName);
            this.creationDate(model.creationDate);
            this.lastInventoryDate(model.lastInventoryDate);
            this.numberOfArchives(model.numberOfArchives);
            this.sizeInBytes(model.sizeInBytes);
        }

        public final String getVaultARN() {
            return this.vaultARN;
        }

        public final void setVaultARN(String vaultARN) {
            this.vaultARN = vaultARN;
        }

        @Override
        public final Builder vaultARN(String vaultARN) {
            this.vaultARN = vaultARN;
            return this;
        }

        public final String getVaultName() {
            return this.vaultName;
        }

        public final void setVaultName(String vaultName) {
            this.vaultName = vaultName;
        }

        @Override
        public final Builder vaultName(String vaultName) {
            this.vaultName = vaultName;
            return this;
        }

        public final String getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getLastInventoryDate() {
            return this.lastInventoryDate;
        }

        public final void setLastInventoryDate(String lastInventoryDate) {
            this.lastInventoryDate = lastInventoryDate;
        }

        @Override
        public final Builder lastInventoryDate(String lastInventoryDate) {
            this.lastInventoryDate = lastInventoryDate;
            return this;
        }

        public final Long getNumberOfArchives() {
            return this.numberOfArchives;
        }

        public final void setNumberOfArchives(Long numberOfArchives) {
            this.numberOfArchives = numberOfArchives;
        }

        @Override
        public final Builder numberOfArchives(Long numberOfArchives) {
            this.numberOfArchives = numberOfArchives;
            return this;
        }

        public final Long getSizeInBytes() {
            return this.sizeInBytes;
        }

        public final void setSizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
        }

        @Override
        public final Builder sizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            return this;
        }

        @Override
        public DescribeVaultResponse build() {
            return new DescribeVaultResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlacierResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVaultResponse> {
        public Builder vaultARN(String var1);

        public Builder vaultName(String var1);

        public Builder creationDate(String var1);

        public Builder lastInventoryDate(String var1);

        public Builder numberOfArchives(Long var1);

        public Builder sizeInBytes(Long var1);
    }
}

