/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PartListElement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PartListElement> {
    private static final SdkField<String> RANGE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RangeInBytes").getter(PartListElement.getter(PartListElement::rangeInBytes)).setter(PartListElement.setter(Builder::rangeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RangeInBytes").build()}).build();
    private static final SdkField<String> SHA256_TREE_HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SHA256TreeHash").getter(PartListElement.getter(PartListElement::sha256TreeHash)).setter(PartListElement.setter(Builder::sha256TreeHash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SHA256TreeHash").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RANGE_IN_BYTES_FIELD, SHA256_TREE_HASH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RangeInBytes", RANGE_IN_BYTES_FIELD);
            this.put("SHA256TreeHash", SHA256_TREE_HASH_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String rangeInBytes;
    private final String sha256TreeHash;

    private PartListElement(BuilderImpl builder) {
        this.rangeInBytes = builder.rangeInBytes;
        this.sha256TreeHash = builder.sha256TreeHash;
    }

    public final String rangeInBytes() {
        return this.rangeInBytes;
    }

    public final String sha256TreeHash() {
        return this.sha256TreeHash;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rangeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.sha256TreeHash());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartListElement)) {
            return false;
        }
        PartListElement other = (PartListElement)obj;
        return Objects.equals(this.rangeInBytes(), other.rangeInBytes()) && Objects.equals(this.sha256TreeHash(), other.sha256TreeHash());
    }

    public final String toString() {
        return ToString.builder((String)"PartListElement").add("RangeInBytes", (Object)this.rangeInBytes()).add("SHA256TreeHash", (Object)this.sha256TreeHash()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RangeInBytes": {
                return Optional.ofNullable(clazz.cast(this.rangeInBytes()));
            }
            case "SHA256TreeHash": {
                return Optional.ofNullable(clazz.cast(this.sha256TreeHash()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PartListElement, T> g) {
        return obj -> g.apply((PartListElement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String rangeInBytes;
        private String sha256TreeHash;

        private BuilderImpl() {
        }

        private BuilderImpl(PartListElement model) {
            this.rangeInBytes(model.rangeInBytes);
            this.sha256TreeHash(model.sha256TreeHash);
        }

        public final String getRangeInBytes() {
            return this.rangeInBytes;
        }

        public final void setRangeInBytes(String rangeInBytes) {
            this.rangeInBytes = rangeInBytes;
        }

        @Override
        public final Builder rangeInBytes(String rangeInBytes) {
            this.rangeInBytes = rangeInBytes;
            return this;
        }

        public final String getSha256TreeHash() {
            return this.sha256TreeHash;
        }

        public final void setSha256TreeHash(String sha256TreeHash) {
            this.sha256TreeHash = sha256TreeHash;
        }

        @Override
        public final Builder sha256TreeHash(String sha256TreeHash) {
            this.sha256TreeHash = sha256TreeHash;
            return this;
        }

        public PartListElement build() {
            return new PartListElement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PartListElement> {
        public Builder rangeInBytes(String var1);

        public Builder sha256TreeHash(String var1);
    }
}

