/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.core.waiters.WaiterState;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.glacier.GlacierAsyncClient;
import software.amazon.awssdk.services.glacier.model.DescribeVaultRequest;
import software.amazon.awssdk.services.glacier.model.DescribeVaultResponse;
import software.amazon.awssdk.services.glacier.model.GlacierRequest;
import software.amazon.awssdk.services.glacier.waiters.GlacierAsyncWaiter;
import software.amazon.awssdk.services.glacier.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultGlacierAsyncWaiter
implements GlacierAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final GlacierAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<DescribeVaultResponse> vaultExistsWaiter;
    private final AsyncWaiter<DescribeVaultResponse> vaultNotExistsWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultGlacierAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (GlacierAsyncClient)GlacierAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.vaultExistsWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeVaultResponse.class).acceptors(DefaultGlacierAsyncWaiter.vaultExistsWaiterAcceptors())).overrideConfiguration(DefaultGlacierAsyncWaiter.vaultExistsWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.vaultNotExistsWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeVaultResponse.class).acceptors(DefaultGlacierAsyncWaiter.vaultNotExistsWaiterAcceptors())).overrideConfiguration(DefaultGlacierAsyncWaiter.vaultNotExistsWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeVaultResponse>> waitUntilVaultExists(DescribeVaultRequest describeVaultRequest) {
        return this.vaultExistsWaiter.runAsync(() -> this.client.describeVault(this.applyWaitersUserAgent(describeVaultRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeVaultResponse>> waitUntilVaultExists(DescribeVaultRequest describeVaultRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.vaultExistsWaiter.runAsync(() -> this.client.describeVault(this.applyWaitersUserAgent(describeVaultRequest)), DefaultGlacierAsyncWaiter.vaultExistsWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeVaultResponse>> waitUntilVaultNotExists(DescribeVaultRequest describeVaultRequest) {
        return this.vaultNotExistsWaiter.runAsync(() -> this.client.describeVault(this.applyWaitersUserAgent(describeVaultRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeVaultResponse>> waitUntilVaultNotExists(DescribeVaultRequest describeVaultRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.vaultNotExistsWaiter.runAsync(() -> this.client.describeVault(this.applyWaitersUserAgent(describeVaultRequest)), DefaultGlacierAsyncWaiter.vaultNotExistsWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeVaultResponse>> vaultExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeVaultResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeVaultResponse>>();
        result.add(new WaitersRuntime.ResponseStatusAcceptor(200, WaiterState.SUCCESS));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultGlacierAsyncWaiter.errorCode(error), "ResourceNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeVaultResponse>> vaultNotExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeVaultResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeVaultResponse>>();
        result.add(new WaitersRuntime.ResponseStatusAcceptor(200, WaiterState.RETRY));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultGlacierAsyncWaiter.errorCode(error), "ResourceNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration vaultExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(15);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration vaultNotExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(15);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static GlacierAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends GlacierRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((GlacierRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements GlacierAsyncWaiter.Builder {
        private GlacierAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public GlacierAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public GlacierAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public GlacierAsyncWaiter.Builder client(GlacierAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public GlacierAsyncWaiter build() {
            return new DefaultGlacierAsyncWaiter(this);
        }
    }
}

