/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glacier.GlacierAsyncClient;
import software.amazon.awssdk.services.glacier.internal.UserAgentUtils;
import software.amazon.awssdk.services.glacier.model.ListMultipartUploadsRequest;
import software.amazon.awssdk.services.glacier.model.ListMultipartUploadsResponse;
import software.amazon.awssdk.services.glacier.model.UploadListElement;

public class ListMultipartUploadsPublisher
implements SdkPublisher<ListMultipartUploadsResponse> {
    private final GlacierAsyncClient client;
    private final ListMultipartUploadsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMultipartUploadsPublisher(GlacierAsyncClient client, ListMultipartUploadsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMultipartUploadsPublisher(GlacierAsyncClient client, ListMultipartUploadsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMultipartUploadsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMultipartUploadsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<UploadListElement> uploadsList() {
        Function<ListMultipartUploadsResponse, Iterator> getIterator = response -> {
            if (response != null && response.uploadsList() != null) {
                return response.uploadsList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMultipartUploadsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMultipartUploadsResponseFetcher
    implements AsyncPageFetcher<ListMultipartUploadsResponse> {
        private ListMultipartUploadsResponseFetcher() {
        }

        public boolean hasNextPage(ListMultipartUploadsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<ListMultipartUploadsResponse> nextPage(ListMultipartUploadsResponse previousPage) {
            if (previousPage == null) {
                return ListMultipartUploadsPublisher.this.client.listMultipartUploads(ListMultipartUploadsPublisher.this.firstRequest);
            }
            return ListMultipartUploadsPublisher.this.client.listMultipartUploads((ListMultipartUploadsRequest)((Object)ListMultipartUploadsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

