/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the Amazon S3 Glacier response to your request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListJobsResponse extends GlacierResponse implements
        ToCopyableBuilder<ListJobsResponse.Builder, ListJobsResponse> {
    private static final SdkField<List<GlacierJobDescription>> JOB_LIST_FIELD = SdkField
            .<List<GlacierJobDescription>> builder(MarshallingType.LIST)
            .memberName("JobList")
            .getter(getter(ListJobsResponse::jobList))
            .setter(setter(Builder::jobList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GlacierJobDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(GlacierJobDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListJobsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_LIST_FIELD, MARKER_FIELD));

    private final List<GlacierJobDescription> jobList;

    private final String marker;

    private ListJobsResponse(BuilderImpl builder) {
        super(builder);
        this.jobList = builder.jobList;
        this.marker = builder.marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the JobList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasJobList() {
        return jobList != null && !(jobList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of job objects. Each job object contains metadata describing the job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJobList} method.
     * </p>
     * 
     * @return A list of job objects. Each job object contains metadata describing the job.
     */
    public final List<GlacierJobDescription> jobList() {
        return jobList;
    }

    /**
     * <p>
     * An opaque string used for pagination that specifies the job at which the listing of jobs should begin. You get
     * the <code>marker</code> value from a previous List Jobs response. You only need to include the marker if you are
     * continuing the pagination of the results started in a previous List Jobs request.
     * </p>
     * 
     * @return An opaque string used for pagination that specifies the job at which the listing of jobs should begin.
     *         You get the <code>marker</code> value from a previous List Jobs response. You only need to include the
     *         marker if you are continuing the pagination of the results started in a previous List Jobs request.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasJobList() ? jobList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsResponse)) {
            return false;
        }
        ListJobsResponse other = (ListJobsResponse) obj;
        return hasJobList() == other.hasJobList() && Objects.equals(jobList(), other.jobList())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListJobsResponse").add("JobList", hasJobList() ? jobList() : null).add("Marker", marker())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobList":
            return Optional.ofNullable(clazz.cast(jobList()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListJobsResponse, T> g) {
        return obj -> g.apply((ListJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlacierResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListJobsResponse> {
        /**
         * <p>
         * A list of job objects. Each job object contains metadata describing the job.
         * </p>
         * 
         * @param jobList
         *        A list of job objects. Each job object contains metadata describing the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobList(Collection<GlacierJobDescription> jobList);

        /**
         * <p>
         * A list of job objects. Each job object contains metadata describing the job.
         * </p>
         * 
         * @param jobList
         *        A list of job objects. Each job object contains metadata describing the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobList(GlacierJobDescription... jobList);

        /**
         * <p>
         * A list of job objects. Each job object contains metadata describing the job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glacier.model.GlacierJobDescription.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.glacier.model.GlacierJobDescription#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glacier.model.GlacierJobDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #jobList(List<GlacierJobDescription>)}.
         * 
         * @param jobList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glacier.model.GlacierJobDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobList(java.util.Collection<GlacierJobDescription>)
         */
        Builder jobList(Consumer<GlacierJobDescription.Builder>... jobList);

        /**
         * <p>
         * An opaque string used for pagination that specifies the job at which the listing of jobs should begin. You
         * get the <code>marker</code> value from a previous List Jobs response. You only need to include the marker if
         * you are continuing the pagination of the results started in a previous List Jobs request.
         * </p>
         * 
         * @param marker
         *        An opaque string used for pagination that specifies the job at which the listing of jobs should begin.
         *        You get the <code>marker</code> value from a previous List Jobs response. You only need to include the
         *        marker if you are continuing the pagination of the results started in a previous List Jobs request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends GlacierResponse.BuilderImpl implements Builder {
        private List<GlacierJobDescription> jobList = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobsResponse model) {
            super(model);
            jobList(model.jobList);
            marker(model.marker);
        }

        public final List<GlacierJobDescription.Builder> getJobList() {
            List<GlacierJobDescription.Builder> result = JobListCopier.copyToBuilder(this.jobList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobList(Collection<GlacierJobDescription.BuilderImpl> jobList) {
            this.jobList = JobListCopier.copyFromBuilder(jobList);
        }

        @Override
        public final Builder jobList(Collection<GlacierJobDescription> jobList) {
            this.jobList = JobListCopier.copy(jobList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobList(GlacierJobDescription... jobList) {
            jobList(Arrays.asList(jobList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobList(Consumer<GlacierJobDescription.Builder>... jobList) {
            jobList(Stream.of(jobList).map(c -> GlacierJobDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public ListJobsResponse build() {
            return new ListJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
