/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.glacier.DefaultGlacierAsyncClientBuilder;
import software.amazon.awssdk.services.glacier.GlacierAsyncClientBuilder;
import software.amazon.awssdk.services.glacier.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.glacier.model.AbortMultipartUploadResponse;
import software.amazon.awssdk.services.glacier.model.AbortVaultLockRequest;
import software.amazon.awssdk.services.glacier.model.AbortVaultLockResponse;
import software.amazon.awssdk.services.glacier.model.AddTagsToVaultRequest;
import software.amazon.awssdk.services.glacier.model.AddTagsToVaultResponse;
import software.amazon.awssdk.services.glacier.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.glacier.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.glacier.model.CompleteVaultLockRequest;
import software.amazon.awssdk.services.glacier.model.CompleteVaultLockResponse;
import software.amazon.awssdk.services.glacier.model.CreateVaultRequest;
import software.amazon.awssdk.services.glacier.model.CreateVaultResponse;
import software.amazon.awssdk.services.glacier.model.DeleteArchiveRequest;
import software.amazon.awssdk.services.glacier.model.DeleteArchiveResponse;
import software.amazon.awssdk.services.glacier.model.DeleteVaultAccessPolicyRequest;
import software.amazon.awssdk.services.glacier.model.DeleteVaultAccessPolicyResponse;
import software.amazon.awssdk.services.glacier.model.DeleteVaultNotificationsRequest;
import software.amazon.awssdk.services.glacier.model.DeleteVaultNotificationsResponse;
import software.amazon.awssdk.services.glacier.model.DeleteVaultRequest;
import software.amazon.awssdk.services.glacier.model.DeleteVaultResponse;
import software.amazon.awssdk.services.glacier.model.DescribeJobRequest;
import software.amazon.awssdk.services.glacier.model.DescribeJobResponse;
import software.amazon.awssdk.services.glacier.model.DescribeVaultRequest;
import software.amazon.awssdk.services.glacier.model.DescribeVaultResponse;
import software.amazon.awssdk.services.glacier.model.GetDataRetrievalPolicyRequest;
import software.amazon.awssdk.services.glacier.model.GetDataRetrievalPolicyResponse;
import software.amazon.awssdk.services.glacier.model.GetJobOutputRequest;
import software.amazon.awssdk.services.glacier.model.GetJobOutputResponse;
import software.amazon.awssdk.services.glacier.model.GetVaultAccessPolicyRequest;
import software.amazon.awssdk.services.glacier.model.GetVaultAccessPolicyResponse;
import software.amazon.awssdk.services.glacier.model.GetVaultLockRequest;
import software.amazon.awssdk.services.glacier.model.GetVaultLockResponse;
import software.amazon.awssdk.services.glacier.model.GetVaultNotificationsRequest;
import software.amazon.awssdk.services.glacier.model.GetVaultNotificationsResponse;
import software.amazon.awssdk.services.glacier.model.InitiateJobRequest;
import software.amazon.awssdk.services.glacier.model.InitiateJobResponse;
import software.amazon.awssdk.services.glacier.model.InitiateMultipartUploadRequest;
import software.amazon.awssdk.services.glacier.model.InitiateMultipartUploadResponse;
import software.amazon.awssdk.services.glacier.model.InitiateVaultLockRequest;
import software.amazon.awssdk.services.glacier.model.InitiateVaultLockResponse;
import software.amazon.awssdk.services.glacier.model.ListJobsRequest;
import software.amazon.awssdk.services.glacier.model.ListJobsResponse;
import software.amazon.awssdk.services.glacier.model.ListMultipartUploadsRequest;
import software.amazon.awssdk.services.glacier.model.ListMultipartUploadsResponse;
import software.amazon.awssdk.services.glacier.model.ListPartsRequest;
import software.amazon.awssdk.services.glacier.model.ListPartsResponse;
import software.amazon.awssdk.services.glacier.model.ListProvisionedCapacityRequest;
import software.amazon.awssdk.services.glacier.model.ListProvisionedCapacityResponse;
import software.amazon.awssdk.services.glacier.model.ListTagsForVaultRequest;
import software.amazon.awssdk.services.glacier.model.ListTagsForVaultResponse;
import software.amazon.awssdk.services.glacier.model.ListVaultsRequest;
import software.amazon.awssdk.services.glacier.model.ListVaultsResponse;
import software.amazon.awssdk.services.glacier.model.PurchaseProvisionedCapacityRequest;
import software.amazon.awssdk.services.glacier.model.PurchaseProvisionedCapacityResponse;
import software.amazon.awssdk.services.glacier.model.RemoveTagsFromVaultRequest;
import software.amazon.awssdk.services.glacier.model.RemoveTagsFromVaultResponse;
import software.amazon.awssdk.services.glacier.model.SetDataRetrievalPolicyRequest;
import software.amazon.awssdk.services.glacier.model.SetDataRetrievalPolicyResponse;
import software.amazon.awssdk.services.glacier.model.SetVaultAccessPolicyRequest;
import software.amazon.awssdk.services.glacier.model.SetVaultAccessPolicyResponse;
import software.amazon.awssdk.services.glacier.model.SetVaultNotificationsRequest;
import software.amazon.awssdk.services.glacier.model.SetVaultNotificationsResponse;
import software.amazon.awssdk.services.glacier.model.UploadArchiveRequest;
import software.amazon.awssdk.services.glacier.model.UploadArchiveResponse;
import software.amazon.awssdk.services.glacier.model.UploadMultipartPartRequest;
import software.amazon.awssdk.services.glacier.model.UploadMultipartPartResponse;
import software.amazon.awssdk.services.glacier.paginators.ListJobsPublisher;
import software.amazon.awssdk.services.glacier.paginators.ListMultipartUploadsPublisher;
import software.amazon.awssdk.services.glacier.paginators.ListPartsPublisher;
import software.amazon.awssdk.services.glacier.paginators.ListVaultsPublisher;
import software.amazon.awssdk.services.glacier.waiters.GlacierAsyncWaiter;

@SdkPublicApi
@ThreadSafe
public interface GlacierAsyncClient
extends SdkClient {
    public static final String SERVICE_NAME = "glacier";
    public static final String SERVICE_METADATA_ID = "glacier";

    public static GlacierAsyncClient create() {
        return (GlacierAsyncClient)GlacierAsyncClient.builder().build();
    }

    public static GlacierAsyncClientBuilder builder() {
        return new DefaultGlacierAsyncClientBuilder();
    }

    default public CompletableFuture<AbortMultipartUploadResponse> abortMultipartUpload(AbortMultipartUploadRequest abortMultipartUploadRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<AbortMultipartUploadResponse> abortMultipartUpload(Consumer<AbortMultipartUploadRequest.Builder> abortMultipartUploadRequest) {
        return this.abortMultipartUpload((AbortMultipartUploadRequest)((Object)((AbortMultipartUploadRequest.Builder)AbortMultipartUploadRequest.builder().applyMutation(abortMultipartUploadRequest)).build()));
    }

    default public CompletableFuture<AbortVaultLockResponse> abortVaultLock(AbortVaultLockRequest abortVaultLockRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<AbortVaultLockResponse> abortVaultLock(Consumer<AbortVaultLockRequest.Builder> abortVaultLockRequest) {
        return this.abortVaultLock((AbortVaultLockRequest)((Object)((AbortVaultLockRequest.Builder)AbortVaultLockRequest.builder().applyMutation(abortVaultLockRequest)).build()));
    }

    default public CompletableFuture<AddTagsToVaultResponse> addTagsToVault(AddTagsToVaultRequest addTagsToVaultRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<AddTagsToVaultResponse> addTagsToVault(Consumer<AddTagsToVaultRequest.Builder> addTagsToVaultRequest) {
        return this.addTagsToVault((AddTagsToVaultRequest)((Object)((AddTagsToVaultRequest.Builder)AddTagsToVaultRequest.builder().applyMutation(addTagsToVaultRequest)).build()));
    }

    default public CompletableFuture<CompleteMultipartUploadResponse> completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CompleteMultipartUploadResponse> completeMultipartUpload(Consumer<CompleteMultipartUploadRequest.Builder> completeMultipartUploadRequest) {
        return this.completeMultipartUpload((CompleteMultipartUploadRequest)((Object)((CompleteMultipartUploadRequest.Builder)CompleteMultipartUploadRequest.builder().applyMutation(completeMultipartUploadRequest)).build()));
    }

    default public CompletableFuture<CompleteVaultLockResponse> completeVaultLock(CompleteVaultLockRequest completeVaultLockRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CompleteVaultLockResponse> completeVaultLock(Consumer<CompleteVaultLockRequest.Builder> completeVaultLockRequest) {
        return this.completeVaultLock((CompleteVaultLockRequest)((Object)((CompleteVaultLockRequest.Builder)CompleteVaultLockRequest.builder().applyMutation(completeVaultLockRequest)).build()));
    }

    default public CompletableFuture<CreateVaultResponse> createVault(CreateVaultRequest createVaultRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CreateVaultResponse> createVault(Consumer<CreateVaultRequest.Builder> createVaultRequest) {
        return this.createVault((CreateVaultRequest)((Object)((CreateVaultRequest.Builder)CreateVaultRequest.builder().applyMutation(createVaultRequest)).build()));
    }

    default public CompletableFuture<DeleteArchiveResponse> deleteArchive(DeleteArchiveRequest deleteArchiveRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteArchiveResponse> deleteArchive(Consumer<DeleteArchiveRequest.Builder> deleteArchiveRequest) {
        return this.deleteArchive((DeleteArchiveRequest)((Object)((DeleteArchiveRequest.Builder)DeleteArchiveRequest.builder().applyMutation(deleteArchiveRequest)).build()));
    }

    default public CompletableFuture<DeleteVaultResponse> deleteVault(DeleteVaultRequest deleteVaultRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteVaultResponse> deleteVault(Consumer<DeleteVaultRequest.Builder> deleteVaultRequest) {
        return this.deleteVault((DeleteVaultRequest)((Object)((DeleteVaultRequest.Builder)DeleteVaultRequest.builder().applyMutation(deleteVaultRequest)).build()));
    }

    default public CompletableFuture<DeleteVaultAccessPolicyResponse> deleteVaultAccessPolicy(DeleteVaultAccessPolicyRequest deleteVaultAccessPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteVaultAccessPolicyResponse> deleteVaultAccessPolicy(Consumer<DeleteVaultAccessPolicyRequest.Builder> deleteVaultAccessPolicyRequest) {
        return this.deleteVaultAccessPolicy((DeleteVaultAccessPolicyRequest)((Object)((DeleteVaultAccessPolicyRequest.Builder)DeleteVaultAccessPolicyRequest.builder().applyMutation(deleteVaultAccessPolicyRequest)).build()));
    }

    default public CompletableFuture<DeleteVaultNotificationsResponse> deleteVaultNotifications(DeleteVaultNotificationsRequest deleteVaultNotificationsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteVaultNotificationsResponse> deleteVaultNotifications(Consumer<DeleteVaultNotificationsRequest.Builder> deleteVaultNotificationsRequest) {
        return this.deleteVaultNotifications((DeleteVaultNotificationsRequest)((Object)((DeleteVaultNotificationsRequest.Builder)DeleteVaultNotificationsRequest.builder().applyMutation(deleteVaultNotificationsRequest)).build()));
    }

    default public CompletableFuture<DescribeJobResponse> describeJob(DescribeJobRequest describeJobRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DescribeJobResponse> describeJob(Consumer<DescribeJobRequest.Builder> describeJobRequest) {
        return this.describeJob((DescribeJobRequest)((Object)((DescribeJobRequest.Builder)DescribeJobRequest.builder().applyMutation(describeJobRequest)).build()));
    }

    default public CompletableFuture<DescribeVaultResponse> describeVault(DescribeVaultRequest describeVaultRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DescribeVaultResponse> describeVault(Consumer<DescribeVaultRequest.Builder> describeVaultRequest) {
        return this.describeVault((DescribeVaultRequest)((Object)((DescribeVaultRequest.Builder)DescribeVaultRequest.builder().applyMutation(describeVaultRequest)).build()));
    }

    default public CompletableFuture<GetDataRetrievalPolicyResponse> getDataRetrievalPolicy(GetDataRetrievalPolicyRequest getDataRetrievalPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetDataRetrievalPolicyResponse> getDataRetrievalPolicy(Consumer<GetDataRetrievalPolicyRequest.Builder> getDataRetrievalPolicyRequest) {
        return this.getDataRetrievalPolicy((GetDataRetrievalPolicyRequest)((Object)((GetDataRetrievalPolicyRequest.Builder)GetDataRetrievalPolicyRequest.builder().applyMutation(getDataRetrievalPolicyRequest)).build()));
    }

    default public CompletableFuture<GetDataRetrievalPolicyResponse> getDataRetrievalPolicy() {
        return this.getDataRetrievalPolicy((GetDataRetrievalPolicyRequest)((Object)GetDataRetrievalPolicyRequest.builder().build()));
    }

    default public <ReturnT> CompletableFuture<ReturnT> getJobOutput(GetJobOutputRequest getJobOutputRequest, AsyncResponseTransformer<GetJobOutputResponse, ReturnT> asyncResponseTransformer) {
        throw new UnsupportedOperationException();
    }

    default public <ReturnT> CompletableFuture<ReturnT> getJobOutput(Consumer<GetJobOutputRequest.Builder> getJobOutputRequest, AsyncResponseTransformer<GetJobOutputResponse, ReturnT> asyncResponseTransformer) {
        return this.getJobOutput((GetJobOutputRequest)((Object)((GetJobOutputRequest.Builder)GetJobOutputRequest.builder().applyMutation(getJobOutputRequest)).build()), asyncResponseTransformer);
    }

    default public CompletableFuture<GetJobOutputResponse> getJobOutput(GetJobOutputRequest getJobOutputRequest, Path destinationPath) {
        return this.getJobOutput(getJobOutputRequest, AsyncResponseTransformer.toFile((Path)destinationPath));
    }

    default public CompletableFuture<GetJobOutputResponse> getJobOutput(Consumer<GetJobOutputRequest.Builder> getJobOutputRequest, Path destinationPath) {
        return this.getJobOutput((GetJobOutputRequest)((Object)((GetJobOutputRequest.Builder)GetJobOutputRequest.builder().applyMutation(getJobOutputRequest)).build()), destinationPath);
    }

    default public CompletableFuture<GetVaultAccessPolicyResponse> getVaultAccessPolicy(GetVaultAccessPolicyRequest getVaultAccessPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetVaultAccessPolicyResponse> getVaultAccessPolicy(Consumer<GetVaultAccessPolicyRequest.Builder> getVaultAccessPolicyRequest) {
        return this.getVaultAccessPolicy((GetVaultAccessPolicyRequest)((Object)((GetVaultAccessPolicyRequest.Builder)GetVaultAccessPolicyRequest.builder().applyMutation(getVaultAccessPolicyRequest)).build()));
    }

    default public CompletableFuture<GetVaultLockResponse> getVaultLock(GetVaultLockRequest getVaultLockRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetVaultLockResponse> getVaultLock(Consumer<GetVaultLockRequest.Builder> getVaultLockRequest) {
        return this.getVaultLock((GetVaultLockRequest)((Object)((GetVaultLockRequest.Builder)GetVaultLockRequest.builder().applyMutation(getVaultLockRequest)).build()));
    }

    default public CompletableFuture<GetVaultNotificationsResponse> getVaultNotifications(GetVaultNotificationsRequest getVaultNotificationsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetVaultNotificationsResponse> getVaultNotifications(Consumer<GetVaultNotificationsRequest.Builder> getVaultNotificationsRequest) {
        return this.getVaultNotifications((GetVaultNotificationsRequest)((Object)((GetVaultNotificationsRequest.Builder)GetVaultNotificationsRequest.builder().applyMutation(getVaultNotificationsRequest)).build()));
    }

    default public CompletableFuture<InitiateJobResponse> initiateJob(InitiateJobRequest initiateJobRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<InitiateJobResponse> initiateJob(Consumer<InitiateJobRequest.Builder> initiateJobRequest) {
        return this.initiateJob((InitiateJobRequest)((Object)((InitiateJobRequest.Builder)InitiateJobRequest.builder().applyMutation(initiateJobRequest)).build()));
    }

    default public CompletableFuture<InitiateMultipartUploadResponse> initiateMultipartUpload(InitiateMultipartUploadRequest initiateMultipartUploadRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<InitiateMultipartUploadResponse> initiateMultipartUpload(Consumer<InitiateMultipartUploadRequest.Builder> initiateMultipartUploadRequest) {
        return this.initiateMultipartUpload((InitiateMultipartUploadRequest)((Object)((InitiateMultipartUploadRequest.Builder)InitiateMultipartUploadRequest.builder().applyMutation(initiateMultipartUploadRequest)).build()));
    }

    default public CompletableFuture<InitiateVaultLockResponse> initiateVaultLock(InitiateVaultLockRequest initiateVaultLockRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<InitiateVaultLockResponse> initiateVaultLock(Consumer<InitiateVaultLockRequest.Builder> initiateVaultLockRequest) {
        return this.initiateVaultLock((InitiateVaultLockRequest)((Object)((InitiateVaultLockRequest.Builder)InitiateVaultLockRequest.builder().applyMutation(initiateVaultLockRequest)).build()));
    }

    default public CompletableFuture<ListJobsResponse> listJobs(ListJobsRequest listJobsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListJobsResponse> listJobs(Consumer<ListJobsRequest.Builder> listJobsRequest) {
        return this.listJobs((ListJobsRequest)((Object)((ListJobsRequest.Builder)ListJobsRequest.builder().applyMutation(listJobsRequest)).build()));
    }

    default public ListJobsPublisher listJobsPaginator(ListJobsRequest listJobsRequest) {
        throw new UnsupportedOperationException();
    }

    default public ListJobsPublisher listJobsPaginator(Consumer<ListJobsRequest.Builder> listJobsRequest) {
        return this.listJobsPaginator((ListJobsRequest)((Object)((ListJobsRequest.Builder)ListJobsRequest.builder().applyMutation(listJobsRequest)).build()));
    }

    default public CompletableFuture<ListMultipartUploadsResponse> listMultipartUploads(ListMultipartUploadsRequest listMultipartUploadsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListMultipartUploadsResponse> listMultipartUploads(Consumer<ListMultipartUploadsRequest.Builder> listMultipartUploadsRequest) {
        return this.listMultipartUploads((ListMultipartUploadsRequest)((Object)((ListMultipartUploadsRequest.Builder)ListMultipartUploadsRequest.builder().applyMutation(listMultipartUploadsRequest)).build()));
    }

    default public ListMultipartUploadsPublisher listMultipartUploadsPaginator(ListMultipartUploadsRequest listMultipartUploadsRequest) {
        throw new UnsupportedOperationException();
    }

    default public ListMultipartUploadsPublisher listMultipartUploadsPaginator(Consumer<ListMultipartUploadsRequest.Builder> listMultipartUploadsRequest) {
        return this.listMultipartUploadsPaginator((ListMultipartUploadsRequest)((Object)((ListMultipartUploadsRequest.Builder)ListMultipartUploadsRequest.builder().applyMutation(listMultipartUploadsRequest)).build()));
    }

    default public CompletableFuture<ListPartsResponse> listParts(ListPartsRequest listPartsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListPartsResponse> listParts(Consumer<ListPartsRequest.Builder> listPartsRequest) {
        return this.listParts((ListPartsRequest)((Object)((ListPartsRequest.Builder)ListPartsRequest.builder().applyMutation(listPartsRequest)).build()));
    }

    default public ListPartsPublisher listPartsPaginator(ListPartsRequest listPartsRequest) {
        throw new UnsupportedOperationException();
    }

    default public ListPartsPublisher listPartsPaginator(Consumer<ListPartsRequest.Builder> listPartsRequest) {
        return this.listPartsPaginator((ListPartsRequest)((Object)((ListPartsRequest.Builder)ListPartsRequest.builder().applyMutation(listPartsRequest)).build()));
    }

    default public CompletableFuture<ListProvisionedCapacityResponse> listProvisionedCapacity(ListProvisionedCapacityRequest listProvisionedCapacityRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListProvisionedCapacityResponse> listProvisionedCapacity(Consumer<ListProvisionedCapacityRequest.Builder> listProvisionedCapacityRequest) {
        return this.listProvisionedCapacity((ListProvisionedCapacityRequest)((Object)((ListProvisionedCapacityRequest.Builder)ListProvisionedCapacityRequest.builder().applyMutation(listProvisionedCapacityRequest)).build()));
    }

    default public CompletableFuture<ListProvisionedCapacityResponse> listProvisionedCapacity() {
        return this.listProvisionedCapacity((ListProvisionedCapacityRequest)((Object)ListProvisionedCapacityRequest.builder().build()));
    }

    default public CompletableFuture<ListTagsForVaultResponse> listTagsForVault(ListTagsForVaultRequest listTagsForVaultRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListTagsForVaultResponse> listTagsForVault(Consumer<ListTagsForVaultRequest.Builder> listTagsForVaultRequest) {
        return this.listTagsForVault((ListTagsForVaultRequest)((Object)((ListTagsForVaultRequest.Builder)ListTagsForVaultRequest.builder().applyMutation(listTagsForVaultRequest)).build()));
    }

    default public CompletableFuture<ListVaultsResponse> listVaults(ListVaultsRequest listVaultsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListVaultsResponse> listVaults(Consumer<ListVaultsRequest.Builder> listVaultsRequest) {
        return this.listVaults((ListVaultsRequest)((Object)((ListVaultsRequest.Builder)ListVaultsRequest.builder().applyMutation(listVaultsRequest)).build()));
    }

    default public CompletableFuture<ListVaultsResponse> listVaults() {
        return this.listVaults((ListVaultsRequest)((Object)ListVaultsRequest.builder().build()));
    }

    default public ListVaultsPublisher listVaultsPaginator() {
        return this.listVaultsPaginator((ListVaultsRequest)((Object)ListVaultsRequest.builder().build()));
    }

    default public ListVaultsPublisher listVaultsPaginator(ListVaultsRequest listVaultsRequest) {
        throw new UnsupportedOperationException();
    }

    default public ListVaultsPublisher listVaultsPaginator(Consumer<ListVaultsRequest.Builder> listVaultsRequest) {
        return this.listVaultsPaginator((ListVaultsRequest)((Object)((ListVaultsRequest.Builder)ListVaultsRequest.builder().applyMutation(listVaultsRequest)).build()));
    }

    default public CompletableFuture<PurchaseProvisionedCapacityResponse> purchaseProvisionedCapacity(PurchaseProvisionedCapacityRequest purchaseProvisionedCapacityRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<PurchaseProvisionedCapacityResponse> purchaseProvisionedCapacity(Consumer<PurchaseProvisionedCapacityRequest.Builder> purchaseProvisionedCapacityRequest) {
        return this.purchaseProvisionedCapacity((PurchaseProvisionedCapacityRequest)((Object)((PurchaseProvisionedCapacityRequest.Builder)PurchaseProvisionedCapacityRequest.builder().applyMutation(purchaseProvisionedCapacityRequest)).build()));
    }

    default public CompletableFuture<PurchaseProvisionedCapacityResponse> purchaseProvisionedCapacity() {
        return this.purchaseProvisionedCapacity((PurchaseProvisionedCapacityRequest)((Object)PurchaseProvisionedCapacityRequest.builder().build()));
    }

    default public CompletableFuture<RemoveTagsFromVaultResponse> removeTagsFromVault(RemoveTagsFromVaultRequest removeTagsFromVaultRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<RemoveTagsFromVaultResponse> removeTagsFromVault(Consumer<RemoveTagsFromVaultRequest.Builder> removeTagsFromVaultRequest) {
        return this.removeTagsFromVault((RemoveTagsFromVaultRequest)((Object)((RemoveTagsFromVaultRequest.Builder)RemoveTagsFromVaultRequest.builder().applyMutation(removeTagsFromVaultRequest)).build()));
    }

    default public CompletableFuture<SetDataRetrievalPolicyResponse> setDataRetrievalPolicy(SetDataRetrievalPolicyRequest setDataRetrievalPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<SetDataRetrievalPolicyResponse> setDataRetrievalPolicy(Consumer<SetDataRetrievalPolicyRequest.Builder> setDataRetrievalPolicyRequest) {
        return this.setDataRetrievalPolicy((SetDataRetrievalPolicyRequest)((Object)((SetDataRetrievalPolicyRequest.Builder)SetDataRetrievalPolicyRequest.builder().applyMutation(setDataRetrievalPolicyRequest)).build()));
    }

    default public CompletableFuture<SetVaultAccessPolicyResponse> setVaultAccessPolicy(SetVaultAccessPolicyRequest setVaultAccessPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<SetVaultAccessPolicyResponse> setVaultAccessPolicy(Consumer<SetVaultAccessPolicyRequest.Builder> setVaultAccessPolicyRequest) {
        return this.setVaultAccessPolicy((SetVaultAccessPolicyRequest)((Object)((SetVaultAccessPolicyRequest.Builder)SetVaultAccessPolicyRequest.builder().applyMutation(setVaultAccessPolicyRequest)).build()));
    }

    default public CompletableFuture<SetVaultNotificationsResponse> setVaultNotifications(SetVaultNotificationsRequest setVaultNotificationsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<SetVaultNotificationsResponse> setVaultNotifications(Consumer<SetVaultNotificationsRequest.Builder> setVaultNotificationsRequest) {
        return this.setVaultNotifications((SetVaultNotificationsRequest)((Object)((SetVaultNotificationsRequest.Builder)SetVaultNotificationsRequest.builder().applyMutation(setVaultNotificationsRequest)).build()));
    }

    default public CompletableFuture<UploadArchiveResponse> uploadArchive(UploadArchiveRequest uploadArchiveRequest, AsyncRequestBody requestBody) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UploadArchiveResponse> uploadArchive(Consumer<UploadArchiveRequest.Builder> uploadArchiveRequest, AsyncRequestBody requestBody) {
        return this.uploadArchive((UploadArchiveRequest)((Object)((UploadArchiveRequest.Builder)UploadArchiveRequest.builder().applyMutation(uploadArchiveRequest)).build()), requestBody);
    }

    default public CompletableFuture<UploadArchiveResponse> uploadArchive(UploadArchiveRequest uploadArchiveRequest, Path sourcePath) {
        return this.uploadArchive(uploadArchiveRequest, AsyncRequestBody.fromFile((Path)sourcePath));
    }

    default public CompletableFuture<UploadArchiveResponse> uploadArchive(Consumer<UploadArchiveRequest.Builder> uploadArchiveRequest, Path sourcePath) {
        return this.uploadArchive((UploadArchiveRequest)((Object)((UploadArchiveRequest.Builder)UploadArchiveRequest.builder().applyMutation(uploadArchiveRequest)).build()), sourcePath);
    }

    default public CompletableFuture<UploadMultipartPartResponse> uploadMultipartPart(UploadMultipartPartRequest uploadMultipartPartRequest, AsyncRequestBody requestBody) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UploadMultipartPartResponse> uploadMultipartPart(Consumer<UploadMultipartPartRequest.Builder> uploadMultipartPartRequest, AsyncRequestBody requestBody) {
        return this.uploadMultipartPart((UploadMultipartPartRequest)((Object)((UploadMultipartPartRequest.Builder)UploadMultipartPartRequest.builder().applyMutation(uploadMultipartPartRequest)).build()), requestBody);
    }

    default public CompletableFuture<UploadMultipartPartResponse> uploadMultipartPart(UploadMultipartPartRequest uploadMultipartPartRequest, Path sourcePath) {
        return this.uploadMultipartPart(uploadMultipartPartRequest, AsyncRequestBody.fromFile((Path)sourcePath));
    }

    default public CompletableFuture<UploadMultipartPartResponse> uploadMultipartPart(Consumer<UploadMultipartPartRequest.Builder> uploadMultipartPartRequest, Path sourcePath) {
        return this.uploadMultipartPart((UploadMultipartPartRequest)((Object)((UploadMultipartPartRequest.Builder)UploadMultipartPartRequest.builder().applyMutation(uploadMultipartPartRequest)).build()), sourcePath);
    }

    default public GlacierAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }
}

