/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glacier.model.GlacierRequest;
import software.amazon.awssdk.services.glacier.transform.DefaultAccountIdSupplier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteArchiveRequest
extends GlacierRequest
implements ToCopyableBuilder<Builder, DeleteArchiveRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(DeleteArchiveRequest.getter(DeleteArchiveRequest::accountId)).setter(DeleteArchiveRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("accountId").build(), DefaultValueTrait.create(DefaultAccountIdSupplier.getInstance())}).build();
    private static final SdkField<String> VAULT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vaultName").getter(DeleteArchiveRequest.getter(DeleteArchiveRequest::vaultName)).setter(DeleteArchiveRequest.setter(Builder::vaultName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("vaultName").build()}).build();
    private static final SdkField<String> ARCHIVE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("archiveId").getter(DeleteArchiveRequest.getter(DeleteArchiveRequest::archiveId)).setter(DeleteArchiveRequest.setter(Builder::archiveId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("archiveId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, VAULT_NAME_FIELD, ARCHIVE_ID_FIELD));
    private final String accountId;
    private final String vaultName;
    private final String archiveId;

    private DeleteArchiveRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.vaultName = builder.vaultName;
        this.archiveId = builder.archiveId;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String vaultName() {
        return this.vaultName;
    }

    public final String archiveId() {
        return this.archiveId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteArchiveRequest)) {
            return false;
        }
        DeleteArchiveRequest other = (DeleteArchiveRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.vaultName(), other.vaultName()) && Objects.equals(this.archiveId(), other.archiveId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteArchiveRequest").add("AccountId", (Object)this.accountId()).add("VaultName", (Object)this.vaultName()).add("ArchiveId", (Object)this.archiveId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "vaultName": {
                return Optional.ofNullable(clazz.cast(this.vaultName()));
            }
            case "archiveId": {
                return Optional.ofNullable(clazz.cast(this.archiveId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteArchiveRequest, T> g) {
        return obj -> g.apply((DeleteArchiveRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlacierRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String vaultName;
        private String archiveId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteArchiveRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.vaultName(model.vaultName);
            this.archiveId(model.archiveId);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getVaultName() {
            return this.vaultName;
        }

        @Override
        public final Builder vaultName(String vaultName) {
            this.vaultName = vaultName;
            return this;
        }

        public final void setVaultName(String vaultName) {
            this.vaultName = vaultName;
        }

        public final String getArchiveId() {
            return this.archiveId;
        }

        @Override
        public final Builder archiveId(String archiveId) {
            this.archiveId = archiveId;
            return this;
        }

        public final void setArchiveId(String archiveId) {
            this.archiveId = archiveId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteArchiveRequest build() {
            return new DeleteArchiveRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlacierRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteArchiveRequest> {
        public Builder accountId(String var1);

        public Builder vaultName(String var1);

        public Builder archiveId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

