/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glacier.model.NotificationEventListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VaultNotificationConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VaultNotificationConfig> {
    private static final SdkField<String> SNS_TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SNSTopic").getter(VaultNotificationConfig.getter(VaultNotificationConfig::snsTopic)).setter(VaultNotificationConfig.setter(Builder::snsTopic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SNSTopic").build()}).build();
    private static final SdkField<List<String>> EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Events").getter(VaultNotificationConfig.getter(VaultNotificationConfig::events)).setter(VaultNotificationConfig.setter(Builder::events)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Events").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNS_TOPIC_FIELD, EVENTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String snsTopic;
    private final List<String> events;

    private VaultNotificationConfig(BuilderImpl builder) {
        this.snsTopic = builder.snsTopic;
        this.events = builder.events;
    }

    public String snsTopic() {
        return this.snsTopic;
    }

    public boolean hasEvents() {
        return this.events != null && !(this.events instanceof SdkAutoConstructList);
    }

    public List<String> events() {
        return this.events;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopic());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvents() ? this.events() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VaultNotificationConfig)) {
            return false;
        }
        VaultNotificationConfig other = (VaultNotificationConfig)obj;
        return Objects.equals(this.snsTopic(), other.snsTopic()) && this.hasEvents() == other.hasEvents() && Objects.equals(this.events(), other.events());
    }

    public String toString() {
        return ToString.builder((String)"VaultNotificationConfig").add("SNSTopic", (Object)this.snsTopic()).add("Events", this.hasEvents() ? this.events() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SNSTopic": {
                return Optional.ofNullable(clazz.cast(this.snsTopic()));
            }
            case "Events": {
                return Optional.ofNullable(clazz.cast(this.events()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VaultNotificationConfig, T> g) {
        return obj -> g.apply((VaultNotificationConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String snsTopic;
        private List<String> events = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VaultNotificationConfig model) {
            this.snsTopic(model.snsTopic);
            this.events(model.events);
        }

        public final String getSnsTopic() {
            return this.snsTopic;
        }

        @Override
        public final Builder snsTopic(String snsTopic) {
            this.snsTopic = snsTopic;
            return this;
        }

        public final void setSnsTopic(String snsTopic) {
            this.snsTopic = snsTopic;
        }

        public final Collection<String> getEvents() {
            if (this.events instanceof SdkAutoConstructList) {
                return null;
            }
            return this.events;
        }

        @Override
        public final Builder events(Collection<String> events) {
            this.events = NotificationEventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(String ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        public final void setEvents(Collection<String> events) {
            this.events = NotificationEventListCopier.copy(events);
        }

        public VaultNotificationConfig build() {
            return new VaultNotificationConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VaultNotificationConfig> {
        public Builder snsTopic(String var1);

        public Builder events(Collection<String> var1);

        public Builder events(String ... var1);
    }
}

