/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glacier.model.VaultLockPolicy;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class VaultLockPolicyMarshaller {
    private static final MarshallingInfo<String> POLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Policy").isBinary(false).build();
    private static final VaultLockPolicyMarshaller INSTANCE = new VaultLockPolicyMarshaller();

    private VaultLockPolicyMarshaller() {
    }

    public static VaultLockPolicyMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(VaultLockPolicy vaultLockPolicy, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)vaultLockPolicy, (String)"vaultLockPolicy");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)vaultLockPolicy.policy(), POLICY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

