/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glacier.model.PurchaseProvisionedCapacityRequest;
import software.amazon.awssdk.services.glacier.transform.DefaultAccountIdSupplier;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PurchaseProvisionedCapacityRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("accountId").isBinary(false).defaultValueSupplier(DefaultAccountIdSupplier.getInstance()).build();
    private static final PurchaseProvisionedCapacityRequestModelMarshaller INSTANCE = new PurchaseProvisionedCapacityRequestModelMarshaller();

    private PurchaseProvisionedCapacityRequestModelMarshaller() {
    }

    public static PurchaseProvisionedCapacityRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PurchaseProvisionedCapacityRequest purchaseProvisionedCapacityRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)purchaseProvisionedCapacityRequest), (String)"purchaseProvisionedCapacityRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)purchaseProvisionedCapacityRequest.accountId(), ACCOUNTID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

