/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glacier.model.DescribeVaultOutput;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeVaultOutputMarshaller {
    private static final MarshallingInfo<String> VAULTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VaultARN").isBinary(false).build();
    private static final MarshallingInfo<String> VAULTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VaultName").isBinary(false).build();
    private static final MarshallingInfo<String> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").isBinary(false).build();
    private static final MarshallingInfo<String> LASTINVENTORYDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastInventoryDate").isBinary(false).build();
    private static final MarshallingInfo<Long> NUMBEROFARCHIVES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfArchives").isBinary(false).build();
    private static final MarshallingInfo<Long> SIZEINBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SizeInBytes").isBinary(false).build();
    private static final DescribeVaultOutputMarshaller INSTANCE = new DescribeVaultOutputMarshaller();

    private DescribeVaultOutputMarshaller() {
    }

    public static DescribeVaultOutputMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DescribeVaultOutput describeVaultOutput, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)describeVaultOutput, (String)"describeVaultOutput");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)describeVaultOutput.vaultARN(), VAULTARN_BINDING);
            protocolMarshaller.marshall((Object)describeVaultOutput.vaultName(), VAULTNAME_BINDING);
            protocolMarshaller.marshall((Object)describeVaultOutput.creationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)describeVaultOutput.lastInventoryDate(), LASTINVENTORYDATE_BINDING);
            protocolMarshaller.marshall((Object)describeVaultOutput.numberOfArchives(), NUMBEROFARCHIVES_BINDING);
            protocolMarshaller.marshall((Object)describeVaultOutput.sizeInBytes(), SIZEINBYTES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

