/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.glacier.GlacierAsyncClient;
import software.amazon.awssdk.services.glacier.model.DescribeVaultOutput;
import software.amazon.awssdk.services.glacier.model.ListVaultsRequest;
import software.amazon.awssdk.services.glacier.model.ListVaultsResponse;

public class ListVaultsPublisher
implements SdkPublisher<ListVaultsResponse> {
    private final GlacierAsyncClient client;
    private final ListVaultsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListVaultsPublisher(GlacierAsyncClient client, ListVaultsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListVaultsPublisher(GlacierAsyncClient client, ListVaultsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListVaultsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListVaultsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<DescribeVaultOutput> vaultList() {
        Function<ListVaultsResponse, Iterator> getIterator = response -> {
            if (response != null && response.vaultList() != null) {
                return response.vaultList().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListVaultsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListVaultsPublisher resume(ListVaultsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListVaultsPublisher(this.client, (ListVaultsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListVaultsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListVaultsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListVaultsResponseFetcher
    implements AsyncPageFetcher<ListVaultsResponse> {
        private ListVaultsResponseFetcher() {
        }

        public boolean hasNextPage(ListVaultsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public CompletableFuture<ListVaultsResponse> nextPage(ListVaultsResponse previousPage) {
            if (previousPage == null) {
                return ListVaultsPublisher.this.client.listVaults(ListVaultsPublisher.this.firstRequest);
            }
            return ListVaultsPublisher.this.client.listVaults((ListVaultsRequest)((Object)ListVaultsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

