/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.glacier.GlacierClient;
import software.amazon.awssdk.services.glacier.model.ListMultipartUploadsRequest;
import software.amazon.awssdk.services.glacier.model.ListMultipartUploadsResponse;
import software.amazon.awssdk.services.glacier.model.UploadListElement;

public class ListMultipartUploadsIterable
implements SdkIterable<ListMultipartUploadsResponse> {
    private final GlacierClient client;
    private final ListMultipartUploadsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMultipartUploadsIterable(GlacierClient client, ListMultipartUploadsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListMultipartUploadsResponseFetcher();
    }

    public Iterator<ListMultipartUploadsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<UploadListElement> uploadsList() {
        Function<ListMultipartUploadsResponse, Iterator> getIterator = response -> {
            if (response != null && response.uploadsList() != null) {
                return response.uploadsList().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListMultipartUploadsIterable resume(ListMultipartUploadsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListMultipartUploadsIterable(this.client, (ListMultipartUploadsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListMultipartUploadsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListMultipartUploadsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListMultipartUploadsResponseFetcher
    implements SyncPageFetcher<ListMultipartUploadsResponse> {
        private ListMultipartUploadsResponseFetcher() {
        }

        public boolean hasNextPage(ListMultipartUploadsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public ListMultipartUploadsResponse nextPage(ListMultipartUploadsResponse previousPage) {
            if (previousPage == null) {
                return ListMultipartUploadsIterable.this.client.listMultipartUploads(ListMultipartUploadsIterable.this.firstRequest);
            }
            return ListMultipartUploadsIterable.this.client.listMultipartUploads((ListMultipartUploadsRequest)((Object)ListMultipartUploadsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

