/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glacier.transform.PartListElementMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PartListElement
implements StructuredPojo,
ToCopyableBuilder<Builder, PartListElement> {
    private final String rangeInBytes;
    private final String sha256TreeHash;

    private PartListElement(BuilderImpl builder) {
        this.rangeInBytes = builder.rangeInBytes;
        this.sha256TreeHash = builder.sha256TreeHash;
    }

    public String rangeInBytes() {
        return this.rangeInBytes;
    }

    public String sha256TreeHash() {
        return this.sha256TreeHash;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rangeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.sha256TreeHash());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartListElement)) {
            return false;
        }
        PartListElement other = (PartListElement)obj;
        return Objects.equals(this.rangeInBytes(), other.rangeInBytes()) && Objects.equals(this.sha256TreeHash(), other.sha256TreeHash());
    }

    public String toString() {
        return ToString.builder((String)"PartListElement").add("RangeInBytes", (Object)this.rangeInBytes()).add("SHA256TreeHash", (Object)this.sha256TreeHash()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RangeInBytes": {
                return Optional.of(clazz.cast(this.rangeInBytes()));
            }
            case "SHA256TreeHash": {
                return Optional.of(clazz.cast(this.sha256TreeHash()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PartListElementMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String rangeInBytes;
        private String sha256TreeHash;

        private BuilderImpl() {
        }

        private BuilderImpl(PartListElement model) {
            this.rangeInBytes(model.rangeInBytes);
            this.sha256TreeHash(model.sha256TreeHash);
        }

        public final String getRangeInBytes() {
            return this.rangeInBytes;
        }

        @Override
        public final Builder rangeInBytes(String rangeInBytes) {
            this.rangeInBytes = rangeInBytes;
            return this;
        }

        public final void setRangeInBytes(String rangeInBytes) {
            this.rangeInBytes = rangeInBytes;
        }

        public final String getSHA256TreeHash() {
            return this.sha256TreeHash;
        }

        @Override
        public final Builder sha256TreeHash(String sha256TreeHash) {
            this.sha256TreeHash = sha256TreeHash;
            return this;
        }

        public final void setSHA256TreeHash(String sha256TreeHash) {
            this.sha256TreeHash = sha256TreeHash;
        }

        public PartListElement build() {
            return new PartListElement(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PartListElement> {
        public Builder rangeInBytes(String var1);

        public Builder sha256TreeHash(String var1);
    }
}

