/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.glacier.model.GlacierRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CompleteMultipartUploadRequest
extends GlacierRequest
implements ToCopyableBuilder<Builder, CompleteMultipartUploadRequest> {
    private final String accountId;
    private final String vaultName;
    private final String uploadId;
    private final String archiveSize;
    private final String checksum;

    private CompleteMultipartUploadRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.vaultName = builder.vaultName;
        this.uploadId = builder.uploadId;
        this.archiveSize = builder.archiveSize;
        this.checksum = builder.checksum;
    }

    public String accountId() {
        return this.accountId;
    }

    public String vaultName() {
        return this.vaultName;
    }

    public String uploadId() {
        return this.uploadId;
    }

    public String archiveSize() {
        return this.archiveSize;
    }

    public String checksum() {
        return this.checksum;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.checksum());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompleteMultipartUploadRequest)) {
            return false;
        }
        CompleteMultipartUploadRequest other = (CompleteMultipartUploadRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.vaultName(), other.vaultName()) && Objects.equals(this.uploadId(), other.uploadId()) && Objects.equals(this.archiveSize(), other.archiveSize()) && Objects.equals(this.checksum(), other.checksum());
    }

    public String toString() {
        return ToString.builder((String)"CompleteMultipartUploadRequest").add("AccountId", (Object)this.accountId()).add("VaultName", (Object)this.vaultName()).add("UploadId", (Object)this.uploadId()).add("ArchiveSize", (Object)this.archiveSize()).add("Checksum", (Object)this.checksum()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.of(clazz.cast(this.accountId()));
            }
            case "vaultName": {
                return Optional.of(clazz.cast(this.vaultName()));
            }
            case "uploadId": {
                return Optional.of(clazz.cast(this.uploadId()));
            }
            case "archiveSize": {
                return Optional.of(clazz.cast(this.archiveSize()));
            }
            case "checksum": {
                return Optional.of(clazz.cast(this.checksum()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlacierRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String vaultName;
        private String uploadId;
        private String archiveSize;
        private String checksum;

        private BuilderImpl() {
        }

        private BuilderImpl(CompleteMultipartUploadRequest model) {
            this.accountId(model.accountId);
            this.vaultName(model.vaultName);
            this.uploadId(model.uploadId);
            this.archiveSize(model.archiveSize);
            this.checksum(model.checksum);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getVaultName() {
            return this.vaultName;
        }

        @Override
        public final Builder vaultName(String vaultName) {
            this.vaultName = vaultName;
            return this;
        }

        public final void setVaultName(String vaultName) {
            this.vaultName = vaultName;
        }

        public final String getUploadId() {
            return this.uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        public final String getArchiveSize() {
            return this.archiveSize;
        }

        @Override
        public final Builder archiveSize(String archiveSize) {
            this.archiveSize = archiveSize;
            return this;
        }

        public final void setArchiveSize(String archiveSize) {
            this.archiveSize = archiveSize;
        }

        public final String getChecksum() {
            return this.checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CompleteMultipartUploadRequest build() {
            return new CompleteMultipartUploadRequest(this);
        }
    }

    public static interface Builder
    extends GlacierRequest.Builder,
    CopyableBuilder<Builder, CompleteMultipartUploadRequest> {
        public Builder accountId(String var1);

        public Builder vaultName(String var1);

        public Builder uploadId(String var1);

        public Builder archiveSize(String var1);

        public Builder checksum(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

