/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glacier.model.UploadListElement;

public class UploadListElementUnmarshaller
implements Unmarshaller<UploadListElement, JsonUnmarshallerContext> {
    private static final UploadListElementUnmarshaller INSTANCE = new UploadListElementUnmarshaller();

    public UploadListElement unmarshall(JsonUnmarshallerContext context) throws Exception {
        UploadListElement.Builder uploadListElementBuilder = UploadListElement.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("MultipartUploadId", targetDepth)) {
                    context.nextToken();
                    uploadListElementBuilder.multipartUploadId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("VaultARN", targetDepth)) {
                    context.nextToken();
                    uploadListElementBuilder.vaultARN((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ArchiveDescription", targetDepth)) {
                    context.nextToken();
                    uploadListElementBuilder.archiveDescription((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("PartSizeInBytes", targetDepth)) {
                    context.nextToken();
                    uploadListElementBuilder.partSizeInBytes((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreationDate", targetDepth)) {
                    context.nextToken();
                    uploadListElementBuilder.creationDate((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (UploadListElement)uploadListElementBuilder.build();
    }

    public static UploadListElementUnmarshaller getInstance() {
        return INSTANCE;
    }
}

