/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glacier.model.InitiateMultipartUploadRequest;
import software.amazon.awssdk.services.glacier.transform.DefaultAccountIdSupplier;

@SdkInternalApi
public class InitiateMultipartUploadRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("accountId").defaultValueSupplier(DefaultAccountIdSupplier.getInstance()).build();
    private static final MarshallingInfo<String> VAULTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("vaultName").build();
    private static final MarshallingInfo<String> ARCHIVEDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-archive-description").build();
    private static final MarshallingInfo<String> PARTSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-part-size").build();
    private static final InitiateMultipartUploadRequestModelMarshaller INSTANCE = new InitiateMultipartUploadRequestModelMarshaller();

    public static InitiateMultipartUploadRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InitiateMultipartUploadRequest initiateMultipartUploadRequest, ProtocolMarshaller protocolMarshaller) {
        if (initiateMultipartUploadRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)initiateMultipartUploadRequest.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)initiateMultipartUploadRequest.vaultName(), VAULTNAME_BINDING);
            protocolMarshaller.marshall((Object)initiateMultipartUploadRequest.archiveDescription(), ARCHIVEDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)initiateMultipartUploadRequest.partSize(), PARTSIZE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

