/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier;

import java.nio.file.Path;
import java.util.function.Consumer;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.regions.ServiceMetadata;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseBytes;
import software.amazon.awssdk.core.sync.ResponseInputStream;
import software.amazon.awssdk.core.sync.StreamingResponseHandler;
import software.amazon.awssdk.services.glacier.DefaultGlacierClientBuilder;
import software.amazon.awssdk.services.glacier.GlacierClientBuilder;
import software.amazon.awssdk.services.glacier.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.glacier.model.AbortMultipartUploadResponse;
import software.amazon.awssdk.services.glacier.model.AbortVaultLockRequest;
import software.amazon.awssdk.services.glacier.model.AbortVaultLockResponse;
import software.amazon.awssdk.services.glacier.model.AddTagsToVaultRequest;
import software.amazon.awssdk.services.glacier.model.AddTagsToVaultResponse;
import software.amazon.awssdk.services.glacier.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.glacier.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.glacier.model.CompleteVaultLockRequest;
import software.amazon.awssdk.services.glacier.model.CompleteVaultLockResponse;
import software.amazon.awssdk.services.glacier.model.CreateVaultRequest;
import software.amazon.awssdk.services.glacier.model.CreateVaultResponse;
import software.amazon.awssdk.services.glacier.model.DeleteArchiveRequest;
import software.amazon.awssdk.services.glacier.model.DeleteArchiveResponse;
import software.amazon.awssdk.services.glacier.model.DeleteVaultAccessPolicyRequest;
import software.amazon.awssdk.services.glacier.model.DeleteVaultAccessPolicyResponse;
import software.amazon.awssdk.services.glacier.model.DeleteVaultNotificationsRequest;
import software.amazon.awssdk.services.glacier.model.DeleteVaultNotificationsResponse;
import software.amazon.awssdk.services.glacier.model.DeleteVaultRequest;
import software.amazon.awssdk.services.glacier.model.DeleteVaultResponse;
import software.amazon.awssdk.services.glacier.model.DescribeJobRequest;
import software.amazon.awssdk.services.glacier.model.DescribeJobResponse;
import software.amazon.awssdk.services.glacier.model.DescribeVaultRequest;
import software.amazon.awssdk.services.glacier.model.DescribeVaultResponse;
import software.amazon.awssdk.services.glacier.model.GetDataRetrievalPolicyRequest;
import software.amazon.awssdk.services.glacier.model.GetDataRetrievalPolicyResponse;
import software.amazon.awssdk.services.glacier.model.GetJobOutputRequest;
import software.amazon.awssdk.services.glacier.model.GetJobOutputResponse;
import software.amazon.awssdk.services.glacier.model.GetVaultAccessPolicyRequest;
import software.amazon.awssdk.services.glacier.model.GetVaultAccessPolicyResponse;
import software.amazon.awssdk.services.glacier.model.GetVaultLockRequest;
import software.amazon.awssdk.services.glacier.model.GetVaultLockResponse;
import software.amazon.awssdk.services.glacier.model.GetVaultNotificationsRequest;
import software.amazon.awssdk.services.glacier.model.GetVaultNotificationsResponse;
import software.amazon.awssdk.services.glacier.model.GlacierException;
import software.amazon.awssdk.services.glacier.model.InitiateJobRequest;
import software.amazon.awssdk.services.glacier.model.InitiateJobResponse;
import software.amazon.awssdk.services.glacier.model.InitiateMultipartUploadRequest;
import software.amazon.awssdk.services.glacier.model.InitiateMultipartUploadResponse;
import software.amazon.awssdk.services.glacier.model.InitiateVaultLockRequest;
import software.amazon.awssdk.services.glacier.model.InitiateVaultLockResponse;
import software.amazon.awssdk.services.glacier.model.InsufficientCapacityException;
import software.amazon.awssdk.services.glacier.model.InvalidParameterValueException;
import software.amazon.awssdk.services.glacier.model.LimitExceededException;
import software.amazon.awssdk.services.glacier.model.ListJobsRequest;
import software.amazon.awssdk.services.glacier.model.ListJobsResponse;
import software.amazon.awssdk.services.glacier.model.ListMultipartUploadsRequest;
import software.amazon.awssdk.services.glacier.model.ListMultipartUploadsResponse;
import software.amazon.awssdk.services.glacier.model.ListPartsRequest;
import software.amazon.awssdk.services.glacier.model.ListPartsResponse;
import software.amazon.awssdk.services.glacier.model.ListProvisionedCapacityRequest;
import software.amazon.awssdk.services.glacier.model.ListProvisionedCapacityResponse;
import software.amazon.awssdk.services.glacier.model.ListTagsForVaultRequest;
import software.amazon.awssdk.services.glacier.model.ListTagsForVaultResponse;
import software.amazon.awssdk.services.glacier.model.ListVaultsRequest;
import software.amazon.awssdk.services.glacier.model.ListVaultsResponse;
import software.amazon.awssdk.services.glacier.model.MissingParameterValueException;
import software.amazon.awssdk.services.glacier.model.PolicyEnforcedException;
import software.amazon.awssdk.services.glacier.model.PurchaseProvisionedCapacityRequest;
import software.amazon.awssdk.services.glacier.model.PurchaseProvisionedCapacityResponse;
import software.amazon.awssdk.services.glacier.model.RemoveTagsFromVaultRequest;
import software.amazon.awssdk.services.glacier.model.RemoveTagsFromVaultResponse;
import software.amazon.awssdk.services.glacier.model.RequestTimeoutException;
import software.amazon.awssdk.services.glacier.model.ResourceNotFoundException;
import software.amazon.awssdk.services.glacier.model.ServiceUnavailableException;
import software.amazon.awssdk.services.glacier.model.SetDataRetrievalPolicyRequest;
import software.amazon.awssdk.services.glacier.model.SetDataRetrievalPolicyResponse;
import software.amazon.awssdk.services.glacier.model.SetVaultAccessPolicyRequest;
import software.amazon.awssdk.services.glacier.model.SetVaultAccessPolicyResponse;
import software.amazon.awssdk.services.glacier.model.SetVaultNotificationsRequest;
import software.amazon.awssdk.services.glacier.model.SetVaultNotificationsResponse;
import software.amazon.awssdk.services.glacier.model.UploadArchiveRequest;
import software.amazon.awssdk.services.glacier.model.UploadArchiveResponse;
import software.amazon.awssdk.services.glacier.model.UploadMultipartPartRequest;
import software.amazon.awssdk.services.glacier.model.UploadMultipartPartResponse;
import software.amazon.awssdk.services.glacier.paginators.ListJobsPaginator;
import software.amazon.awssdk.services.glacier.paginators.ListMultipartUploadsPaginator;
import software.amazon.awssdk.services.glacier.paginators.ListPartsPaginator;
import software.amazon.awssdk.services.glacier.paginators.ListVaultsPaginator;
import software.amazon.awssdk.utils.SdkAutoCloseable;

public interface GlacierClient
extends SdkClient,
SdkAutoCloseable {
    public static final String SERVICE_NAME = "glacier";

    public static GlacierClient create() {
        return (GlacierClient)GlacierClient.builder().build();
    }

    public static GlacierClientBuilder builder() {
        return new DefaultGlacierClientBuilder();
    }

    default public AbortMultipartUploadResponse abortMultipartUpload(AbortMultipartUploadRequest abortMultipartUploadRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public AbortMultipartUploadResponse abortMultipartUpload(Consumer<AbortMultipartUploadRequest.Builder> abortMultipartUploadRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        return this.abortMultipartUpload((AbortMultipartUploadRequest)((Object)((AbortMultipartUploadRequest.Builder)AbortMultipartUploadRequest.builder().apply(abortMultipartUploadRequest)).build()));
    }

    default public AbortVaultLockResponse abortVaultLock(AbortVaultLockRequest abortVaultLockRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public AbortVaultLockResponse abortVaultLock(Consumer<AbortVaultLockRequest.Builder> abortVaultLockRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        return this.abortVaultLock((AbortVaultLockRequest)((Object)((AbortVaultLockRequest.Builder)AbortVaultLockRequest.builder().apply(abortVaultLockRequest)).build()));
    }

    default public AddTagsToVaultResponse addTagsToVault(AddTagsToVaultRequest addTagsToVaultRequest) throws InvalidParameterValueException, MissingParameterValueException, ResourceNotFoundException, LimitExceededException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public AddTagsToVaultResponse addTagsToVault(Consumer<AddTagsToVaultRequest.Builder> addTagsToVaultRequest) throws InvalidParameterValueException, MissingParameterValueException, ResourceNotFoundException, LimitExceededException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        return this.addTagsToVault((AddTagsToVaultRequest)((Object)((AddTagsToVaultRequest.Builder)AddTagsToVaultRequest.builder().apply(addTagsToVaultRequest)).build()));
    }

    default public CompleteMultipartUploadResponse completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public CompleteMultipartUploadResponse completeMultipartUpload(Consumer<CompleteMultipartUploadRequest.Builder> completeMultipartUploadRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        return this.completeMultipartUpload((CompleteMultipartUploadRequest)((Object)((CompleteMultipartUploadRequest.Builder)CompleteMultipartUploadRequest.builder().apply(completeMultipartUploadRequest)).build()));
    }

    default public CompleteVaultLockResponse completeVaultLock(CompleteVaultLockRequest completeVaultLockRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public CompleteVaultLockResponse completeVaultLock(Consumer<CompleteVaultLockRequest.Builder> completeVaultLockRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        return this.completeVaultLock((CompleteVaultLockRequest)((Object)((CompleteVaultLockRequest.Builder)CompleteVaultLockRequest.builder().apply(completeVaultLockRequest)).build()));
    }

    default public CreateVaultResponse createVault(CreateVaultRequest createVaultRequest) throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, LimitExceededException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public CreateVaultResponse createVault(Consumer<CreateVaultRequest.Builder> createVaultRequest) throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, LimitExceededException, SdkServiceException, SdkClientException, GlacierException {
        return this.createVault((CreateVaultRequest)((Object)((CreateVaultRequest.Builder)CreateVaultRequest.builder().apply(createVaultRequest)).build()));
    }

    default public DeleteArchiveResponse deleteArchive(DeleteArchiveRequest deleteArchiveRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public DeleteArchiveResponse deleteArchive(Consumer<DeleteArchiveRequest.Builder> deleteArchiveRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        return this.deleteArchive((DeleteArchiveRequest)((Object)((DeleteArchiveRequest.Builder)DeleteArchiveRequest.builder().apply(deleteArchiveRequest)).build()));
    }

    default public DeleteVaultResponse deleteVault(DeleteVaultRequest deleteVaultRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public DeleteVaultResponse deleteVault(Consumer<DeleteVaultRequest.Builder> deleteVaultRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        return this.deleteVault((DeleteVaultRequest)((Object)((DeleteVaultRequest.Builder)DeleteVaultRequest.builder().apply(deleteVaultRequest)).build()));
    }

    default public DeleteVaultAccessPolicyResponse deleteVaultAccessPolicy(DeleteVaultAccessPolicyRequest deleteVaultAccessPolicyRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public DeleteVaultAccessPolicyResponse deleteVaultAccessPolicy(Consumer<DeleteVaultAccessPolicyRequest.Builder> deleteVaultAccessPolicyRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        return this.deleteVaultAccessPolicy((DeleteVaultAccessPolicyRequest)((Object)((DeleteVaultAccessPolicyRequest.Builder)DeleteVaultAccessPolicyRequest.builder().apply(deleteVaultAccessPolicyRequest)).build()));
    }

    default public DeleteVaultNotificationsResponse deleteVaultNotifications(DeleteVaultNotificationsRequest deleteVaultNotificationsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public DeleteVaultNotificationsResponse deleteVaultNotifications(Consumer<DeleteVaultNotificationsRequest.Builder> deleteVaultNotificationsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        return this.deleteVaultNotifications((DeleteVaultNotificationsRequest)((Object)((DeleteVaultNotificationsRequest.Builder)DeleteVaultNotificationsRequest.builder().apply(deleteVaultNotificationsRequest)).build()));
    }

    default public DescribeJobResponse describeJob(DescribeJobRequest describeJobRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public DescribeJobResponse describeJob(Consumer<DescribeJobRequest.Builder> describeJobRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        return this.describeJob((DescribeJobRequest)((Object)((DescribeJobRequest.Builder)DescribeJobRequest.builder().apply(describeJobRequest)).build()));
    }

    default public DescribeVaultResponse describeVault(DescribeVaultRequest describeVaultRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public DescribeVaultResponse describeVault(Consumer<DescribeVaultRequest.Builder> describeVaultRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        return this.describeVault((DescribeVaultRequest)((Object)((DescribeVaultRequest.Builder)DescribeVaultRequest.builder().apply(describeVaultRequest)).build()));
    }

    default public GetDataRetrievalPolicyResponse getDataRetrievalPolicy(GetDataRetrievalPolicyRequest getDataRetrievalPolicyRequest) throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public GetDataRetrievalPolicyResponse getDataRetrievalPolicy(Consumer<GetDataRetrievalPolicyRequest.Builder> getDataRetrievalPolicyRequest) throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        return this.getDataRetrievalPolicy((GetDataRetrievalPolicyRequest)((Object)((GetDataRetrievalPolicyRequest.Builder)GetDataRetrievalPolicyRequest.builder().apply(getDataRetrievalPolicyRequest)).build()));
    }

    default public <ReturnT> ReturnT getJobOutput(GetJobOutputRequest getJobOutputRequest, StreamingResponseHandler<GetJobOutputResponse, ReturnT> streamingResponseHandler) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public GetJobOutputResponse getJobOutput(GetJobOutputRequest getJobOutputRequest, Path filePath) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        return (GetJobOutputResponse)((Object)this.getJobOutput(getJobOutputRequest, StreamingResponseHandler.toFile((Path)filePath)));
    }

    default public ResponseInputStream<GetJobOutputResponse> getJobOutput(GetJobOutputRequest getJobOutputRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        return (ResponseInputStream)this.getJobOutput(getJobOutputRequest, StreamingResponseHandler.toInputStream());
    }

    default public ResponseBytes<GetJobOutputResponse> getJobOutputBytes(GetJobOutputRequest getJobOutputRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        return (ResponseBytes)this.getJobOutput(getJobOutputRequest, StreamingResponseHandler.toBytes());
    }

    default public GetVaultAccessPolicyResponse getVaultAccessPolicy(GetVaultAccessPolicyRequest getVaultAccessPolicyRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public GetVaultAccessPolicyResponse getVaultAccessPolicy(Consumer<GetVaultAccessPolicyRequest.Builder> getVaultAccessPolicyRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        return this.getVaultAccessPolicy((GetVaultAccessPolicyRequest)((Object)((GetVaultAccessPolicyRequest.Builder)GetVaultAccessPolicyRequest.builder().apply(getVaultAccessPolicyRequest)).build()));
    }

    default public GetVaultLockResponse getVaultLock(GetVaultLockRequest getVaultLockRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public GetVaultLockResponse getVaultLock(Consumer<GetVaultLockRequest.Builder> getVaultLockRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        return this.getVaultLock((GetVaultLockRequest)((Object)((GetVaultLockRequest.Builder)GetVaultLockRequest.builder().apply(getVaultLockRequest)).build()));
    }

    default public GetVaultNotificationsResponse getVaultNotifications(GetVaultNotificationsRequest getVaultNotificationsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public GetVaultNotificationsResponse getVaultNotifications(Consumer<GetVaultNotificationsRequest.Builder> getVaultNotificationsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        return this.getVaultNotifications((GetVaultNotificationsRequest)((Object)((GetVaultNotificationsRequest.Builder)GetVaultNotificationsRequest.builder().apply(getVaultNotificationsRequest)).build()));
    }

    default public InitiateJobResponse initiateJob(InitiateJobRequest initiateJobRequest) throws ResourceNotFoundException, PolicyEnforcedException, InvalidParameterValueException, MissingParameterValueException, InsufficientCapacityException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public InitiateJobResponse initiateJob(Consumer<InitiateJobRequest.Builder> initiateJobRequest) throws ResourceNotFoundException, PolicyEnforcedException, InvalidParameterValueException, MissingParameterValueException, InsufficientCapacityException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        return this.initiateJob((InitiateJobRequest)((Object)((InitiateJobRequest.Builder)InitiateJobRequest.builder().apply(initiateJobRequest)).build()));
    }

    default public InitiateMultipartUploadResponse initiateMultipartUpload(InitiateMultipartUploadRequest initiateMultipartUploadRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public InitiateMultipartUploadResponse initiateMultipartUpload(Consumer<InitiateMultipartUploadRequest.Builder> initiateMultipartUploadRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        return this.initiateMultipartUpload((InitiateMultipartUploadRequest)((Object)((InitiateMultipartUploadRequest.Builder)InitiateMultipartUploadRequest.builder().apply(initiateMultipartUploadRequest)).build()));
    }

    default public InitiateVaultLockResponse initiateVaultLock(InitiateVaultLockRequest initiateVaultLockRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public InitiateVaultLockResponse initiateVaultLock(Consumer<InitiateVaultLockRequest.Builder> initiateVaultLockRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        return this.initiateVaultLock((InitiateVaultLockRequest)((Object)((InitiateVaultLockRequest.Builder)InitiateVaultLockRequest.builder().apply(initiateVaultLockRequest)).build()));
    }

    default public ListJobsResponse listJobs(ListJobsRequest listJobsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public ListJobsResponse listJobs(Consumer<ListJobsRequest.Builder> listJobsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        return this.listJobs((ListJobsRequest)((Object)((ListJobsRequest.Builder)ListJobsRequest.builder().apply(listJobsRequest)).build()));
    }

    default public ListJobsPaginator listJobsIterable(ListJobsRequest listJobsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public ListMultipartUploadsResponse listMultipartUploads(ListMultipartUploadsRequest listMultipartUploadsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public ListMultipartUploadsResponse listMultipartUploads(Consumer<ListMultipartUploadsRequest.Builder> listMultipartUploadsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        return this.listMultipartUploads((ListMultipartUploadsRequest)((Object)((ListMultipartUploadsRequest.Builder)ListMultipartUploadsRequest.builder().apply(listMultipartUploadsRequest)).build()));
    }

    default public ListMultipartUploadsPaginator listMultipartUploadsIterable(ListMultipartUploadsRequest listMultipartUploadsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public ListPartsResponse listParts(ListPartsRequest listPartsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public ListPartsResponse listParts(Consumer<ListPartsRequest.Builder> listPartsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        return this.listParts((ListPartsRequest)((Object)((ListPartsRequest.Builder)ListPartsRequest.builder().apply(listPartsRequest)).build()));
    }

    default public ListPartsPaginator listPartsIterable(ListPartsRequest listPartsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public ListProvisionedCapacityResponse listProvisionedCapacity(ListProvisionedCapacityRequest listProvisionedCapacityRequest) throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public ListProvisionedCapacityResponse listProvisionedCapacity(Consumer<ListProvisionedCapacityRequest.Builder> listProvisionedCapacityRequest) throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        return this.listProvisionedCapacity((ListProvisionedCapacityRequest)((Object)((ListProvisionedCapacityRequest.Builder)ListProvisionedCapacityRequest.builder().apply(listProvisionedCapacityRequest)).build()));
    }

    default public ListTagsForVaultResponse listTagsForVault(ListTagsForVaultRequest listTagsForVaultRequest) throws InvalidParameterValueException, MissingParameterValueException, ResourceNotFoundException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForVaultResponse listTagsForVault(Consumer<ListTagsForVaultRequest.Builder> listTagsForVaultRequest) throws InvalidParameterValueException, MissingParameterValueException, ResourceNotFoundException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        return this.listTagsForVault((ListTagsForVaultRequest)((Object)((ListTagsForVaultRequest.Builder)ListTagsForVaultRequest.builder().apply(listTagsForVaultRequest)).build()));
    }

    default public ListVaultsResponse listVaults(ListVaultsRequest listVaultsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public ListVaultsResponse listVaults(Consumer<ListVaultsRequest.Builder> listVaultsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        return this.listVaults((ListVaultsRequest)((Object)((ListVaultsRequest.Builder)ListVaultsRequest.builder().apply(listVaultsRequest)).build()));
    }

    default public ListVaultsPaginator listVaultsIterable(ListVaultsRequest listVaultsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public PurchaseProvisionedCapacityResponse purchaseProvisionedCapacity(PurchaseProvisionedCapacityRequest purchaseProvisionedCapacityRequest) throws InvalidParameterValueException, MissingParameterValueException, LimitExceededException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public PurchaseProvisionedCapacityResponse purchaseProvisionedCapacity(Consumer<PurchaseProvisionedCapacityRequest.Builder> purchaseProvisionedCapacityRequest) throws InvalidParameterValueException, MissingParameterValueException, LimitExceededException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        return this.purchaseProvisionedCapacity((PurchaseProvisionedCapacityRequest)((Object)((PurchaseProvisionedCapacityRequest.Builder)PurchaseProvisionedCapacityRequest.builder().apply(purchaseProvisionedCapacityRequest)).build()));
    }

    default public RemoveTagsFromVaultResponse removeTagsFromVault(RemoveTagsFromVaultRequest removeTagsFromVaultRequest) throws InvalidParameterValueException, MissingParameterValueException, ResourceNotFoundException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public RemoveTagsFromVaultResponse removeTagsFromVault(Consumer<RemoveTagsFromVaultRequest.Builder> removeTagsFromVaultRequest) throws InvalidParameterValueException, MissingParameterValueException, ResourceNotFoundException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        return this.removeTagsFromVault((RemoveTagsFromVaultRequest)((Object)((RemoveTagsFromVaultRequest.Builder)RemoveTagsFromVaultRequest.builder().apply(removeTagsFromVaultRequest)).build()));
    }

    default public SetDataRetrievalPolicyResponse setDataRetrievalPolicy(SetDataRetrievalPolicyRequest setDataRetrievalPolicyRequest) throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public SetDataRetrievalPolicyResponse setDataRetrievalPolicy(Consumer<SetDataRetrievalPolicyRequest.Builder> setDataRetrievalPolicyRequest) throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        return this.setDataRetrievalPolicy((SetDataRetrievalPolicyRequest)((Object)((SetDataRetrievalPolicyRequest.Builder)SetDataRetrievalPolicyRequest.builder().apply(setDataRetrievalPolicyRequest)).build()));
    }

    default public SetVaultAccessPolicyResponse setVaultAccessPolicy(SetVaultAccessPolicyRequest setVaultAccessPolicyRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public SetVaultAccessPolicyResponse setVaultAccessPolicy(Consumer<SetVaultAccessPolicyRequest.Builder> setVaultAccessPolicyRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        return this.setVaultAccessPolicy((SetVaultAccessPolicyRequest)((Object)((SetVaultAccessPolicyRequest.Builder)SetVaultAccessPolicyRequest.builder().apply(setVaultAccessPolicyRequest)).build()));
    }

    default public SetVaultNotificationsResponse setVaultNotifications(SetVaultNotificationsRequest setVaultNotificationsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public SetVaultNotificationsResponse setVaultNotifications(Consumer<SetVaultNotificationsRequest.Builder> setVaultNotificationsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        return this.setVaultNotifications((SetVaultNotificationsRequest)((Object)((SetVaultNotificationsRequest.Builder)SetVaultNotificationsRequest.builder().apply(setVaultNotificationsRequest)).build()));
    }

    default public UploadArchiveResponse uploadArchive(UploadArchiveRequest uploadArchiveRequest, RequestBody requestBody) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, RequestTimeoutException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public UploadArchiveResponse uploadArchive(UploadArchiveRequest uploadArchiveRequest, Path filePath) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, RequestTimeoutException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        return this.uploadArchive(uploadArchiveRequest, RequestBody.of((Path)filePath));
    }

    default public UploadMultipartPartResponse uploadMultipartPart(UploadMultipartPartRequest uploadMultipartPartRequest, RequestBody requestBody) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, RequestTimeoutException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public UploadMultipartPartResponse uploadMultipartPart(UploadMultipartPartRequest uploadMultipartPartRequest, Path filePath) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, RequestTimeoutException, ServiceUnavailableException, SdkServiceException, SdkClientException, GlacierException {
        return this.uploadMultipartPart(uploadMultipartPartRequest, RequestBody.of((Path)filePath));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_NAME);
    }
}

