/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glacier.model.SetDataRetrievalPolicyRequest;
import software.amazon.awssdk.services.glacier.transform.DefaultAccountIdSupplier;

@SdkInternalApi
public class SetDataRetrievalPolicyRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("accountId").defaultValueSupplier(DefaultAccountIdSupplier.getInstance()).build();
    private static final MarshallingInfo<StructuredPojo> POLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Policy").build();
    private static final SetDataRetrievalPolicyRequestModelMarshaller INSTANCE = new SetDataRetrievalPolicyRequestModelMarshaller();

    public static SetDataRetrievalPolicyRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SetDataRetrievalPolicyRequest setDataRetrievalPolicyRequest, ProtocolMarshaller protocolMarshaller) {
        if (setDataRetrievalPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)setDataRetrievalPolicyRequest.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)setDataRetrievalPolicyRequest.policy(), POLICY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

