/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.glacier.model.GlacierRequest;
import software.amazon.awssdk.services.glacier.model.VaultNotificationConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SetVaultNotificationsRequest
extends GlacierRequest
implements ToCopyableBuilder<Builder, SetVaultNotificationsRequest> {
    private final String accountId;
    private final String vaultName;
    private final VaultNotificationConfig vaultNotificationConfig;

    private SetVaultNotificationsRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.vaultName = builder.vaultName;
        this.vaultNotificationConfig = builder.vaultNotificationConfig;
    }

    public String accountId() {
        return this.accountId;
    }

    public String vaultName() {
        return this.vaultName;
    }

    public VaultNotificationConfig vaultNotificationConfig() {
        return this.vaultNotificationConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vaultNotificationConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetVaultNotificationsRequest)) {
            return false;
        }
        SetVaultNotificationsRequest other = (SetVaultNotificationsRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.vaultName(), other.vaultName()) && Objects.equals(this.vaultNotificationConfig(), other.vaultNotificationConfig());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.accountId() != null) {
            sb.append("AccountId: ").append(this.accountId()).append(",");
        }
        if (this.vaultName() != null) {
            sb.append("VaultName: ").append(this.vaultName()).append(",");
        }
        if (this.vaultNotificationConfig() != null) {
            sb.append("VaultNotificationConfig: ").append(this.vaultNotificationConfig()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.of(clazz.cast(this.accountId()));
            }
            case "vaultName": {
                return Optional.of(clazz.cast(this.vaultName()));
            }
            case "vaultNotificationConfig": {
                return Optional.of(clazz.cast(this.vaultNotificationConfig()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlacierRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String vaultName;
        private VaultNotificationConfig vaultNotificationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(SetVaultNotificationsRequest model) {
            this.accountId(model.accountId);
            this.vaultName(model.vaultName);
            this.vaultNotificationConfig(model.vaultNotificationConfig);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getVaultName() {
            return this.vaultName;
        }

        @Override
        public final Builder vaultName(String vaultName) {
            this.vaultName = vaultName;
            return this;
        }

        public final void setVaultName(String vaultName) {
            this.vaultName = vaultName;
        }

        public final VaultNotificationConfig.Builder getVaultNotificationConfig() {
            return this.vaultNotificationConfig != null ? this.vaultNotificationConfig.toBuilder() : null;
        }

        @Override
        public final Builder vaultNotificationConfig(VaultNotificationConfig vaultNotificationConfig) {
            this.vaultNotificationConfig = vaultNotificationConfig;
            return this;
        }

        public final void setVaultNotificationConfig(VaultNotificationConfig.BuilderImpl vaultNotificationConfig) {
            this.vaultNotificationConfig = vaultNotificationConfig != null ? vaultNotificationConfig.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SetVaultNotificationsRequest build() {
            return new SetVaultNotificationsRequest(this);
        }
    }

    public static interface Builder
    extends GlacierRequest.Builder,
    CopyableBuilder<Builder, SetVaultNotificationsRequest> {
        public Builder accountId(String var1);

        public Builder vaultName(String var1);

        public Builder vaultNotificationConfig(VaultNotificationConfig var1);

        default public Builder vaultNotificationConfig(Consumer<VaultNotificationConfig.Builder> vaultNotificationConfig) {
            return this.vaultNotificationConfig((VaultNotificationConfig)((VaultNotificationConfig.Builder)VaultNotificationConfig.builder().apply(vaultNotificationConfig)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

